package net.rmi.rjs.fc;

import j2d.ImageUtils;
import j2d.ShortImageBean;
import net.rmi.rjs.jobs.FractalLogic;
import net.rmi.rjs.jobs.FractalShortImageBean;
import utils.SystemUtils;

import java.awt.*;
import java.io.File;

/**
 * Created by IntelliJ IDEA.
 * User: lyon
 * Date: Jul 4, 2005
 * Time: 3:11:01 AM
 * Copyright 2005, DocJava, Inc.
 */
public class Utils {
    public static void computeStrip(Point from, Point to, String outputFileName) {
        Dimension d = new Dimension(400, 800);
        Point position = new Point(0, 0);
        computeStrip(d, position, from, to, outputFileName);
    }

    public static void computeStrip(Dimension d, Point position, Point from, Point to, String outputFileName) {
        ShortImageBean sib = new ShortImageBean(d.width, d.height);
        FractalShortImageBean s = new FractalShortImageBean(position, from, to);
        FractalLogic fl = new FractalLogic();

        s.setR(sib.getR());
        s.setG(sib.getG());
        s.setB(sib.getB());
        System.out.println("Processing piece Image fp=" + from.x + " tp=" + to.y);
        for (int y = from.y; y < to.y; y++) {
            for (int x = from.x; x < to.x; x++) {
                fl.mandelbrot(x, y, s.getR(), s.getG(), s.getB());
            }
        }
        String ds = SystemUtils.getUserHome() + SystemUtils.getDirectorySeparator() +
                "rjs" + SystemUtils.getDirectorySeparator();
        //ImageUtils.saveAsPPMgz(s.getProcessedImage(), args[0]+ "Fractals_out1.ppm.gz");
        File f = new File(ds);
        if (!f.exists()) f.mkdir();
        String fn = ds + outputFileName;

        f = new File(fn);

        System.out.println("output file:" + f);
        Image i = s.getProcessedImage();
        System.out.println("Height= " + i.getHeight(null));
        System.out.println("Width= " + i.getWidth(null));
        ImageUtils.saveAsPPMJar(i, f);
        System.exit(0);
    }

    public static void computeJob(int jobNumber) {
        Point from = new Point(0, 100 * (jobNumber - 1));
        computeStrip(from, new Point(400, from.y + 100), "Fractals_out" +
                jobNumber +
                ".ppm.jar");
    }
}
