/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package net.rmi.rjs.fc;

import gui.In;
import utils.SystemUtils;

import javax.swing.*;
import java.awt.*;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;

/**
 * @author Francisco Castellanos
 *
 */
public class TestFractalJobs {
	
	int numImages = 8;
	Image[] images = new Image[numImages];
	Dimension d = new Dimension(400, 400);
	FractalsImageFrame frame;
	Calendar cal;
	FractalsMonitorThread fmt;
	
	public TestFractalJobs(){
	}
	public static void computeImages()  {
        try {
            SystemUtils.runMain(FractalsJob_1.class);
            SystemUtils.runMain(FractalsJob_2.class);
            SystemUtils.runMain(FractalsJob_3.class);
            SystemUtils.runMain(FractalsJob_4.class);
            SystemUtils.runMain(FractalsJob_5.class);
            SystemUtils.runMain(FractalsJob_6.class);
            SystemUtils.runMain(FractalsJob_7.class);
            SystemUtils.runMain(FractalsJob_8.class);
        } catch (IOException e) {
            In.message(e);

        }

    }
	public static void main(String[] args) {

        String outDir = System.getProperty("user.home")
                + File.separatorChar + "rjs";
		if (args.length > 0){
			outDir = args[0];
		}
        File f = new File(outDir);
        if (!f.exists()) {
            System.out.println(outDir+" does not exist, making directory...");
            f.mkdir();
            computeImages();
        }
		TestFractalJobs tfj = new TestFractalJobs();
		tfj.CreateGUI();
		tfj.startOutputMonitor(f);
	}
	
	public void CreateGUI(){
		frame = new FractalsImageFrame( images, this);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setSize(d.width, d.height);
        frame.setVisible(true);
	}
	
	public void startOutputMonitor(File f){
		fmt= new FractalsMonitorThread(images, f.getAbsolutePath(), this);
		fmt.start();
	}
	
	public boolean getMonitorStatus(){
		//System.out.println(fmt.getStatus());
		return fmt.getStatus(); 
	}
	public void repaintImagePanel(int indx){
		frame.getMainPanel().repaintPanel(indx);
	}
	
}

