/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package net.rmi.rjs;

import bookExamples.ch15Streams.Unzipper;
import gui.In;
import gui.run.RunJob;
import net.web.UrlUtils;
import utils.OsUtils;
import utils.SystemUtils;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.prefs.Preferences;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Aug 6, 2005
 * <p/>
 * Time: 3:19:05 PM
 */
public class MacScreenSaverUtils {

    private static String screenSaverDirectoryName =
            SystemUtils.getUserHome() +
            "/Library/Screen Savers/" ;
    private static File outputJarFile = new File(
            screenSaverDirectoryName+
            "screenSaver.jar");
    //download the screen saver in:
    // http://show.docjava.com:8086/book/cgij/code/jnlp/libs/mac/screenSaver.jar
    public static void downloadScreenSaverJar()
            throws IOException {

        URL screenSaverUrl = getResourceUrl();
        UrlUtils.getUrl(screenSaverUrl,outputJarFile);

    }
    public static void testStartRunCheckThread(){
        startRunCheckThread();
        guiKillCS();
    }

    private static void guiKillCS() {
        while(In.getBoolean(("keep cs running?"))){
            try {
                Thread.sleep(5000);
            } catch (InterruptedException e) {
                In.message(e);

            }
        }
        Preferences p = Preferences.systemRoot();
        p.put(csKillKey, "true");
    }

    private static final String csKillKey = "timeToKillCS";
    public static void startRunCheckThread(){
        final Preferences p = Preferences.systemRoot();
        p.put(csKillKey, "false");
        new RunJob(1){
            public void run(){
                final Preferences p = Preferences.systemRoot();
                String value = p.get(csKillKey, "false");
                if (value == null) return;
                if (value.equals("false")) return;
                killCS();//kill the CS
            }
        };
    }
    private static class RunCheckThread extends Thread {

        public void run() {
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
            }
            final Preferences p = Preferences.systemRoot();
            String value = p.get(csKillKey, "false");
            if (value == null) return;
            if (value.equals("false")) return;
            killCS();//kill the CS
        }
    }
    private static void killCS() {
        System.out.println("cs is dead");
        System.exit(0);
    }

    private static URL getResourceUrl() throws MalformedURLException {
        URL screenSaverUrl= new URL("http://show.docjava.com:8086" +
                "/book/cgij/code/jnlp/libs/mac/screenSaver.jar");
        return screenSaverUrl;
    }

    public static void uncompressScreenSaverJar(){
        Unzipper.uncompressJarFile(outputJarFile);
        outputJarFile.deleteOnExit();
    }

    public static void main(String[] args) {
          SystemUtils.printProps();
        //installScreenSaver();

        testStartRunCheckThread();
    }
    private static boolean dateIsGood() {
        try {
            File dataDir = new File(screenSaverDirectoryName);
            long dataDirTime = dataDir.getCanonicalFile().lastModified();
            URL resourceUrl = getResourceUrl();
            final URLConnection urlConnection = resourceUrl.openConnection();
            long resourceUrlTime = urlConnection.getLastModified();
            return dataDirTime > resourceUrlTime;
        } catch (IOException e) {
            In.message(e);
        }
        return
                false;
    }

    public static void installScreenSaver() {
        if (dateIsGood()) return;
        if (!OsUtils.isMacOs()){
            In.message("This only works on macos! Program exits!");
            return;
        }
        if (!In.getBoolean("install screen saver?")) return;
        System.out.println("check for output in:"+outputJarFile);
        try {
            downloadScreenSaverJar();
            uncompressScreenSaverJar();
        } catch (IOException e) {
            In.message(e);

        }
        System.out.println("finished!");
        In.message("set screen saver to ScreenSaver and check hot corners!");
    }


}
