package net.compute;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;

public class ComputeThread extends
        Thread {
    ObjectInputStream ois;
    ObjectOutputStream oos;

    ComputeThread(Socket s)
            throws IOException {
        // read the computable object from the
        // object input stream.
        // write the answer to the object output stream.
        oos =
                new ObjectOutputStream(
                        s.getOutputStream());

        ois =
                new ObjectInputStream(
                        s.getInputStream());
    }

    public void run() {
        try {
            Object o = ois.readObject();
            if (!(o instanceof ComputableObject)) {
                System.out.println("Bad object!");
                return;
            }
            ComputableObject
                    co = (ComputableObject) o;
            Serializable ans = co.compute();
            oos.writeObject(ans);
            oos.close();
            ois.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}