package math.numerics;

public class PBC {

   private PBC(){}             // prohibit instantiation

   public static double position(final double r, final double size) {
      int n = (int) (Math.abs(r)/size);
      if(r > size)
        return r - n*size;
      else if (r < 0)
        return r + (n+1)*size;
      else
        return r;
   }

   public static int position(final int r, final int size) {
      if(r >= 0)
        return r % size;
      else {
        int n = 1 + ((-r)/size);
        return  r + n*size;
      }
   }

   public static double separation(final double dr, final double size) {
      // assumes particles are not located in different periodic images
      if(dr > 0.5*size)
        return dr - size;
      else if (dr < -0.5*size)
        return dr + size;
      else
        return dr;
   }

   public static int separation(final int dr, final int size) {
      // assumes particles are not located in different periodic images
      if(dr > size/2)
        return dr - size;
      else if (dr < -size/2)
        return dr + size;
      else
        return dr;
   }


}
