package math.fourierTransforms;

import ip.gui.frames.FFTFrame;
import ip.transforms.ColorUtils;

public class FFTShort3 {

    FFTFrame parent;

    private ColorUtils CU = new ColorUtils();
    private FFTrgb imgFFTrgb = new FFTrgb();

    private short[] imageData_R;
    private short[] imageData_G;
    private short[] imageData_B;


    public FFTShort3(FFTFrame _parent) {

        parent = _parent;
        initData();
    }

    private void initData() {
        imgFFTrgb.DisplayLogPSD = true;
        int w = parent.getImageWidth();
        int h = parent.getImageHeight();
        // separated R,G,B values
        //System.out.println("getting the 1-D arrays");
        get1DArraysFromParent();
        //System.out.println("init complete");
    }

    public void get1DArraysFromParent() {
        if (parent == null)
            System.out.println(
                    "ER:get1DArraysFromParent, parent==null");
        if (parent.getImageWidth() != parent.getImageHeight())
            System.out.println("ComplexRgb:transforms.fft Non-square image detected");
        int N = parent.getImageWidth() * parent.getImageHeight();
        imageData_R = new short[N];
        imageData_G = new short[N];
        imageData_B = new short[N];

        for (int x = 0; x < parent.getImageWidth(); x++)
            for (int y = 0; y < parent.getImageHeight(); y++) {
                imageData_R[x + y * parent.getImageWidth()] = parent.shortImageBean.getR()[x][y];
                imageData_G[x + y * parent.getImageWidth()] = parent.shortImageBean.getG()[x][y];
                imageData_B[x + y * parent.getImageWidth()] = parent.shortImageBean.getB()[x][y];
            }
    }

    public FFTrgb FFTrgb = new FFTrgb();

    public FFTrgb getVsFft() {
        return FFTrgb;
    }

    public int[] fft() {
        FFTrgb.DisplayLogPSD = true;
        if (parent.getImageWidth() != parent.getImageHeight())
            System.out.println("ComplexRgb:transforms.fft ER! Non-square image");
        return FFTrgb.forward2dFFT(
                imageData_R,
                imageData_G,
                imageData_B,
                parent.getImageWidth(),
                parent.getImageHeight());
    }

    public int[] getPhaseImage() {
        FFTrgb.DisplayLogPSD = true;
        if (parent.getImageWidth() != parent.getImageHeight())
            System.out.println("ComplexRgb:transforms.fft ER! Non-square image");
        FFTrgb.forward2dFFT(
                imageData_R,
                imageData_G,
                imageData_B,
                parent.getImageWidth(),
                parent.getImageHeight());
        return FFTrgb.getPhaseImage();
    }

    public void complexMult(FFTShort3 other) {
        FFTrgb.complexMult(other.getVsFft());
    }

    public int[] getPsd() {
        return FFTrgb.getPsd();
    }


    public int[] ifft() {
        return FFTrgb.reverse2dFFT();
    }


}







