/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package math;

public class Mat4f {
    private float matrix[][] = new float[4][4];

    public Mat4f() {
        matrix[0][0] = (float) 1;
        matrix[1][1] = (float) 1;
        matrix[2][2] = (float) 1;
        matrix[3][3] = (float) 1;
    }

    public float[][] getMatrix() {
        return matrix;
    }

    public void setMatrix(float[][] matrix) {
        this.matrix = matrix;
    }

    public static Mat4f crossproduct(
            Mat4f a, Mat4f b) {
        Mat4f c = new Mat4f();
        c.getMatrix()[0][0] =
        a.getMatrix()[0][0] * b.getMatrix()[0][0] +
        a.getMatrix()[0][1] * b.getMatrix()[1][0] +
        a.getMatrix()[0][2] * b.getMatrix()[2][0] +
        a.getMatrix()[0][3] * b.getMatrix()[3][0];
        c.getMatrix()[0][1] =
        a.getMatrix()[0][0] * b.getMatrix()[0][1] +
        a.getMatrix()[0][1] * b.getMatrix()[1][1] +
        a.getMatrix()[0][2] * b.getMatrix()[2][1] +
        a.getMatrix()[0][3] * b.getMatrix()[3][1];
        c.getMatrix()[0][2] =
        a.getMatrix()[0][0] * b.getMatrix()[0][2] +
        a.getMatrix()[0][1] * b.getMatrix()[1][2] +
        a.getMatrix()[0][2] * b.getMatrix()[2][2] +
        a.getMatrix()[0][3] * b.getMatrix()[3][2];
        c.getMatrix()[0][3] =
        a.getMatrix()[0][0] * b.getMatrix()[0][3] +
        a.getMatrix()[0][1] * b.getMatrix()[1][3] +
        a.getMatrix()[0][2] * b.getMatrix()[2][3] +
        a.getMatrix()[0][3] * b.getMatrix()[3][3];
        c.getMatrix()[1][0] =
        a.getMatrix()[1][0] * b.getMatrix()[0][0] +
        a.getMatrix()[1][1] * b.getMatrix()[1][0] +
        a.getMatrix()[1][2] * b.getMatrix()[2][0] +
        a.getMatrix()[1][3] * b.getMatrix()[3][0];
        c.getMatrix()[1][1] =
        a.getMatrix()[1][0] * b.getMatrix()[0][1] +
        a.getMatrix()[1][1] * b.getMatrix()[1][1] +
        a.getMatrix()[1][2] * b.getMatrix()[2][1] +
        a.getMatrix()[1][3] * b.getMatrix()[3][1];
        c.getMatrix()[1][2] =
        a.getMatrix()[1][0] * b.getMatrix()[0][2] +
        a.getMatrix()[1][1] * b.getMatrix()[1][2] +
        a.getMatrix()[1][2] * b.getMatrix()[2][2] +
        a.getMatrix()[1][3] * b.getMatrix()[3][2];
        c.getMatrix()[1][3] =
        a.getMatrix()[1][0] * b.getMatrix()[0][3] +
        a.getMatrix()[1][1] * b.getMatrix()[1][3] +
        a.getMatrix()[1][2] * b.getMatrix()[2][3] +
        a.getMatrix()[1][3] * b.getMatrix()[3][3];
        c.getMatrix()[2][0] =
        a.getMatrix()[2][0] * b.getMatrix()[0][0] +
        a.getMatrix()[2][1] * b.getMatrix()[1][0] +
        a.getMatrix()[2][2] * b.getMatrix()[2][0] +
        a.getMatrix()[2][3] * b.getMatrix()[3][0];
        c.getMatrix()[2][1] =
        a.getMatrix()[2][0] * b.getMatrix()[0][1] +
        a.getMatrix()[2][1] * b.getMatrix()[1][1] +
        a.getMatrix()[2][2] * b.getMatrix()[2][1] +
        a.getMatrix()[2][3] * b.getMatrix()[3][1];
        c.getMatrix()[2][2] =
        a.getMatrix()[2][0] * b.getMatrix()[0][2] +
        a.getMatrix()[2][1] * b.getMatrix()[1][2] +
        a.getMatrix()[2][2] * b.getMatrix()[2][2] +
        a.getMatrix()[2][3] * b.getMatrix()[3][2];
        c.getMatrix()[2][3] =
        a.getMatrix()[2][0] * b.getMatrix()[0][3] +
        a.getMatrix()[2][1] * b.getMatrix()[1][3] +
        a.getMatrix()[2][2] * b.getMatrix()[2][3] +
        a.getMatrix()[2][3] * b.getMatrix()[3][3];
        return c;
    }
}
