package j3d.utils.sceneGraphInspector;

import javax.media.j3d.*;
import javax.vecmath.Color3f;
import java.util.ArrayList;
import java.util.Enumeration;

public class SceneGraphNode {

    /**
     * The type by which this instance variable was declared in its class.
     * The object 's type, object.getClass(), itself may be a subtype of the
     * declaredType.
     */
    private String role;
    private Object userData;
    private SceneGraphObject sgo;
    private ArrayList children = new ArrayList();

    public SceneGraphNode(String aRole, SceneGraphObject sgo) {
        role = aRole;
        this.userData = sgo == null ? null : sgo.getUserData();
        this.sgo = sgo;
        buildChildrenList();
    }

    private void buildChildrenList() {
        if (sgo instanceof Group) {
            Group g = (Group) sgo;
            if (!g.getCapability(g.ALLOW_CHILDREN_READ)) return;
            Enumeration e = g.getAllChildren();
            while (e.hasMoreElements())
                children.add(new Child("child", (SceneGraphObject) e.nextElement()));
            return;
        }

        if (sgo instanceof Shape3D) {
            Shape3D s = (Shape3D) sgo;
            if (s.getCapability(s.ALLOW_APPEARANCE_READ))
                children.add(new Child("Appearance", s.getAppearance()));
            if (s.getCapability(s.ALLOW_GEOMETRY_READ))
                children.add(new Child("Geometry",
                        (SceneGraphObject) s.getAllGeometries().nextElement()));
            return;
        }

        if (sgo instanceof Background) {
            Background b = (Background) sgo;
            if (b.getCapability(b.ALLOW_GEOMETRY_READ))
                children.add(new Child("Geometry", b.getGeometry()));
            if (b.getCapability(b.ALLOW_COLOR_READ)) {
                Color3f color = new Color3f();
                b.getColor(color);
                SceneGraphObject c = new ColoringAttributes(color, 0);
                children.add(new Child("Color", c));
            }
            return;
        }

    }

    public ArrayList getChildren() {
        return children;
    }

    public Object getName() {
        return userData;
    }

    public String getRole() {
        return role;
    }

    public Object getValue() {
        return sgo;
    }

    public static String shortClassName(Class c) {
        String s = c.toString();
        int index = s.lastIndexOf(".");
        return index == -1 ? s : s.substring(index + 1);
    }

    public String toString() {
        return
                (userData == null ? role : userData) + ": " +
                (sgo == null ? "null" : shortClassName(sgo.getClass()));
    }

}