package j3d.utils.sceneGraphInspector;

import javax.media.j3d.BranchGroup;
import javax.swing.*;
import java.awt.*;

public class SceneGraphInspectorFrame extends JFrame {

    public SceneGraphInspectorFrame(BranchGroup bg, int x, int y) {
        setTitle(bg.getClass().toString());
        setSize(500, 400);
        setLocation(x, y);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        // inspect this object
        Container contentPane = getContentPane();
        contentPane.add(sceneInspectorModelPane(bg), "Center");
    }

    public static JScrollPane sceneInspectorModelPane(BranchGroup bg) {
        SceneGraphTreeModel model = new SceneGraphTreeModel();
        model.setRoot(new SceneGraphNode(null, bg));

        // construct and showAndRegister tree
        JTree tree = new JTree(model);
//    tree.addTreeSelectionListener(this);
        JScrollPane scrollPane = new JScrollPane(tree);
        return scrollPane;
    }

//  public void valueChanged(TreeSelectionEvent e) {
//    TreePath path = tree.getSelectionPath();
//    if (path == null) return;
//    SceneGraphNode n = (SceneGraphNode)path.getLastPathComponent();
//    System.out.println(n);
//    Node node = (Node) n.getValue();
//    if (!(node instanceof TransformGroup)) return;
//    Transform3D t = new Transform3D();
//    ((TransformGroup)node).getTransform(t);
//    System.out.println(t);
//  }

}