package j3d.utils.sceneGraphBuilderUtils;

import j3d.utils.sceneGraphInspector.SceneGraphTreeModel;

import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.swing.*;
import java.awt.*;

public class Window extends JFrame {

    static {
        setUI();
    }

    public Window(String title, Canvas3D canvas,
                  JComponent controls, BranchGroup scene) {
        super(title);
        setContentPane(new JSplitPane(JSplitPane.VERTICAL_SPLIT,
                buildTop(controls, canvas),
                buildBottom(scene)));
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        pack();
        setVisible(true);
    }

    private JScrollPane buildBottom(BranchGroup scene) {
        JPanel treePane = new JPanel(new BorderLayout());
        treePane.add(BorderLayout.CENTER, SceneGraphTreeModel.buildPane(scene));
        return new JScrollPane(treePane);
    }

    private JPanel buildTop(JComponent controlsPane, Canvas3D canvas) {
        JPanel top = new JPanel(new BorderLayout());
        // This may be either a single Box of controls or a JTabbedPane of controls.
        top.add(BorderLayout.WEST, controlsPane);
        // Put it in a box so that it won't insist on keeping its height if expanded.
        Box canvasPane = Box.createHorizontalBox();
        canvasPane.add(canvas);
        canvasPane.setPreferredSize(new Dimension(400, 400));
        top.add(BorderLayout.CENTER, canvasPane);
        return top;
    }

    public static void setUI() {
        String lafName = UIManager.getSystemLookAndFeelClassName();
        if (!lafName.endsWith("WindowsLookAndFeel"))
            lafName = UIManager.getCrossPlatformLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(lafName);
        } catch (ClassNotFoundException cnfe) {
        } catch (InstantiationException cnfe) {
        } catch (IllegalAccessException cnfe) {
        } catch (UnsupportedLookAndFeelException cnfe) {
        }
    }

}