package j3d.utils.sceneGraphBuilderUtils;

import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.*;
import javax.swing.border.BevelBorder;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import java.awt.*;
import java.text.DecimalFormat;

public class TransformGroupWrapper {

    private Box box = Box.createVerticalBox();
    private double currentRotX = 0, currentRotY = 0, currentRotZ = 0;
    private DecimalFormat df1 = new DecimalFormat("    0.00 ;   -0.00 ");
    private DecimalFormat df2 = new DecimalFormat("  00.00 ; -00.00 ");
    private Transform3D identity = new Transform3D();
    private Matrix4d m = new Matrix4d();
    private Point3d p = new Point3d();
    private Dimension size = new Dimension();
    private Transform3D t0 = new Transform3D(),
    t1 = new Transform3D();
    private JTextArea ta = new JTextArea(4, 0);
    private TransformGroup tg;
    private Vector3d v = new Vector3d();
    private int width = 0;

    public TransformGroupWrapper(TransformGroup tg) {
        this.tg = tg;
        tg.setCapability(tg.ALLOW_TRANSFORM_READ);
        tg.setCapability(tg.ALLOW_TRANSFORM_WRITE);
        box.setBorder(new BevelBorder(BevelBorder.LOWERED));
        box.add(ta);
        box.add(Box.createHorizontalStrut(160));
        displayTransform(identity);
    }

    private void displayTransform(Transform3D t) {
        t.get(m);
        ta.setText(matrixToString(m));
    }

    private String matrixToString(Matrix4d m) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 4; i++) {
            for (int j = 0; j < 4; j++) {
                double d = m.getElement(i, j);
                sb.append(Math.abs(d) < 10 ? df1.format(d) : df2.format(d));
            }
            if (i < 3) sb.append("\n");
        }
        return sb.toString();
    }

    public double getRotX() {
        return currentRotX;
    }

    public double getRotY() {
        return currentRotY;
    }

    public double getRotZ() {
        return currentRotZ;
    }

    public Box getTextArea() {
        return box;
    }

    public double getX() {
        return transformPoint().x;
    }

    public double getY() {
        return transformPoint().y;
    }

    public double getZ() {
        return transformPoint().z;
    }

    public void reset() {
        tg.setTransform(identity);
        currentRotX = currentRotY = currentRotZ = 0;
        setRotX(currentRotX);
    }

    public void setRotX(double degrees) {
        setRotation(ETransformGroup.X, degrees - currentRotX);
        currentRotX = degrees;
    }

    public void setRotY(double degrees) {
        setRotation(ETransformGroup.Y, degrees - currentRotY);
        currentRotY = degrees;
    }

    public void setRotZ(double degrees) {
        setRotation(ETransformGroup.Z, degrees - currentRotZ);
        currentRotZ = degrees;
    }

    public void setRotation(int axis, double degrees) {
        t0.set(identity);
        ETransformGroup.rotate(t0, axis, Math.toRadians(degrees));
        tg.getTransform(t1);
        t1.mul(t0);
        tg.setTransform(t1);
        displayTransform(t1);
    }

    public void setTranslation(int axis, double f) {
        transformPoint();
        if (axis == ETransformGroup.X)
            v.set(f, p.y, p.z);
        else if (axis == ETransformGroup.Y)
            v.set(p.x, f, p.z);
        else if (axis == ETransformGroup.Z) v.set(p.x, p.y, f);
        t0.setTranslation(v);
        tg.setTransform(t0);
        displayTransform(t0);
    }

    public void setX(double f) {
        setTranslation(ETransformGroup.X, f);
    }

    public void setY(double f) {
        setTranslation(ETransformGroup.Y, f);
    }

    public void setZ(double f) {
        setTranslation(ETransformGroup.Z, f);
    }

    private Point3d transformPoint() {
        return transformPoint(0, 0, 0);
    }

    private Point3d transformPoint(float x, float y, float z) {
        tg.getTransform(t0);
        p.set(x, y, z);
        t0.transform(p);
        return p;
    }

}

