package j3d.utils.sceneGraphBuilderUtils;

import com.sun.j3d.utils.universe.MultiTransformGroup;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;

import javax.media.j3d.*;
import javax.swing.*;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3d;

public class ControlledUniverse extends SimpleUniverse {

    static {
        Window.setUI();
    }

    public static Color3f plum = new Color3f(0.6f, 0.3f, 0.3f);
    public static Color3f preDawn = new Color3f(0.4f, 0.5f, 0.5f);


    /**
     * This keeps the SimpleUniverse from creating its own canvas along with
     * a JFrame in which to display it.
     */
    public ControlledUniverse() {
        super(makeCanvas());
    }

    public ControlledUniverse(String title, BranchGroup scene, Color3f bgColor) {
        this();
        Box controls = Box.createVerticalBox();
        ETransformGroup
                tg = ETransformGroup
                .controlledSubgraph(controls,
                        "Figure and axes",
                        new Node[]{scene, SGBuilder.axes(20)},
                        false);

        Background background = SGBuilder.background(bgColor);
        background.setApplicationBounds(new BoundingSphere());

        scene = SGBuilder.newBranchGroup("Surface demo", background);
        scene.addChild(tg);
        scene.compile();
        addBranchGraph(scene);
        new Window(title, getCanvas(), controls, scene);
    }

    public static Canvas3D makeCanvas() {
        return new Canvas3D(getPreferredConfiguration());
    }

    public void positionTheViewingPlatform(Vector3d v) {
        Transform3D t = new Transform3D();
        t.setTranslation(v);
        ViewingPlatform vp = getViewingPlatform();
        View view = vp.getViewers()[0].getView();
        view.setBackClipDistance(50);
        MultiTransformGroup mtg = vp.getMultiTransformGroup();
        TransformGroup tg = mtg.getTransformGroup(0);
        tg.setTransform(t);
    }

}