package j3d.utils.propertyEditors;

import javax.swing.*;
import java.awt.*;

public class PropertyEditorFactory {

    public static final int BUTTON = 0, CHECKBOX = 1;

    private static JPanel booleanPE(String name, Object obj, int type) {
        return
                titledPanel(name,
                        type == BUTTON ?
                (PropertyEditorBuilder) new PEButtonBuilder(obj, name) :
                (PropertyEditorBuilder) new PECheckBoxBuilder(obj, name));
    }

    public static JPanel buttonPE(String name, Object obj) {
        return booleanPE(name, obj, PropertyEditorFactory.BUTTON);
    }

    public static JPanel checkBoxPE(String name, Object obj) {
        return booleanPE(name, obj, PropertyEditorFactory.CHECKBOX);
    }

    public static JPanel comboBoxPE(String name, String[] choices, Object obj) {
        return titledPanel(name, new PEComboBoxBuilder(choices, obj, name));
    }

    public static JPanel radioButtonGroupPE(String name, String[] choices,
                                            Object obj) {
        return titledPanel(name, new PERadioButtonGroupBuilder(choices, obj, name));
    }

    public static JPanel sliderPE(String name, int low, int high, Object obj, boolean timer) {
        return sliderPE(name, low, high, obj, JSlider.HORIZONTAL, timer);
    }

    public static JPanel sliderPE(String name, int low, int high, Object obj) {
        return sliderPE(name, low, high, obj, JSlider.HORIZONTAL, true);
    }

    public static JPanel sliderPE(String name, int low, int high, Object obj,
                                  int orientation, boolean timer) {
        return
                titledPanel(name,
                        new PESliderBuilder(orientation, low, high, obj, name, timer));
    }

    public static JPanel sliderPE(String name, int low, int high,
                                  int majorTickIncr, int minorTickIncr,
                                  Object obj, boolean timer) {
        return sliderPE(name, low, high, majorTickIncr, minorTickIncr, obj,
                JSlider.HORIZONTAL, timer);
    }

    public static JPanel sliderPE(String name, int low, int high,
                                  int majorTickIncr, int minorTickIncr,
                                  Object obj, int orientation, boolean timer) {
        return
                titledPanel(name,
                        new PESliderBuilder(orientation, low, high,
                                majorTickIncr, minorTickIncr,
                                obj, name, timer));
    }

    private static JPanel titledPanel(String name, PropertyEditorBuilder su) {
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(BorderFactory.createTitledBorder(name));
        p.add(su.getSwingJComponent(), BorderLayout.CENTER);
        return p;
    }

}