package j3d.utils.propertyEditors;

import javax.swing.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;


public class PERadioButtonBuilder extends PEAbstractButtonBuilder {

    public PERadioButtonBuilder(final Object obj, String name) {
        super(obj, name, new JRadioButton());
    }

    public void addEventListener(final Object obj, final Method writer) {
        button.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if (button.isSelected())
                    writeToObject(obj, writer, button.getText());
            }
        });
    }

    public void setSwingJComponentFromObject(final Object obj, final Method reader) {
        button.setSelected(button.getText().equals(readFromObject(obj, reader)));
    }

}