package j3d.utils;

import j3d.polyViewer.vec3.Vec3;
import j3d.polyViewer.vec3.Vec3FunctionInterface;

public class TriangleGeometryUtils {
    private Vec3FunctionInterface pv3 = null;

    public TriangleGeometryUtils(Vec3FunctionInterface pv3) {
        this.pv3 = pv3;

    }

    public Vec3[][] getTriangles(int n1,
                                 int n2,
                                 double r1,
                                 double r2) {
        Vec3[][] triList = new Vec3[2 * n1 * n2][3];


        for (int i1 = 0; i1 < n1; i1++)
            for (int i2 = 0; i2 < n2; i2++) {
                triList[2 * (i1 * n2 + i2)][0] = getPolarPoint(i1,
                        i2,
                        n1,
                        n2,
                        r1,
                        r2);    // half a trapezoid
                triList[2 * (i1 * n2 + i2)][1] =
                        getPolarPoint(i1 + 1, i2, n1, n2, r1, r2);
                triList[2 * (i1 * n2 + i2)][2] =
                        getPolarPoint(i1 + 1, i2 + 1, n1, n2, r1, r2);

                triList[2 * (i1 * n2 + i2) + 1][0] =
                        getPolarPoint(i1, i2, n1, n2, r1, r2);  // 2nd half
                triList[2 * (i1 * n2 + i2) + 1][1] =
                        getPolarPoint(i1 + 1, i2 + 1, n1, n2, r1, r2);
                triList[2 * (i1 * n2 + i2) + 1][2] =
                        getPolarPoint(i1, i2 + 1, n1, n2, r1, r2);
            }

        return triList;
    }

    private Vec3 getPolarPoint(int i1,
                            int i2,
                            int n1,
                            int n2,
                            double r1,
                            double r2) {
        double theta1 = 2 * Math.PI * i1 / n1;
        double theta2 = 2 * Math.PI * i2 / n2;


        return pv3.getPolarVec3(r1, theta1, r2, theta2);
    }


}