package j3d.utils;

/*
      @(#)TransparencyAttributesEditor.java 1.2 01/08/01 11:02:26

***************************************************************
"Copyright (c) 2001 Sun Microsystems, Inc. All Rights Reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

-Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

-Redistribution in binary form must reproduce the above copyright notice, this
list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.

Neither the name of Sun Microsystems, Inc. or the names of contributors may be
used to endorse or promote products derived from this software without
specific prior written permission.

This software is provided "AS IS," without a warranty of any kind. ALL
EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

You acknowledge that Software is not designed,licensed or intended for use in
the design, construction, operation or maintenance of any nuclear facility."

****************************************************************************
*/

import gui.run.*;

import javax.media.j3d.TransparencyAttributes;
import javax.swing.*;
import java.awt.*;


public class TransparencyAttributesEditor extends JPanel
        implements Java3DExplorerConstants {

    // TransparencyAttributes
    TransparencyAttributes transpAttr;
    float transparency;
    int mode;
    int srcBlendFunction;
    int dstBlendFunction;

    public TransparencyAttributesEditor(TransparencyAttributes init) {
        transpAttr = init;
        transparency = transpAttr.getTransparency();
        mode = transpAttr.getTransparencyMode();
        srcBlendFunction = transpAttr.getSrcBlendFunction();
        dstBlendFunction = transpAttr.getDstBlendFunction();

        setLayout(new GridLayout(4, 1));

        FloatLabelJSlider transparencySlider = new FloatLabelJSlider("Transparency", 0.1f, 0.0f, 1.0f, transparency);
        transparencySlider.setMajorTickSpacing(0.1f);
        transparencySlider.setPaintTicks(true);
        transparencySlider.addFloatListener(new FloatListener() {
            public void floatChanged(FloatEvent e) {
                transparency = e.getValue();
                transpAttr.setTransparency(transparency);
            }
        });
        add(transparencySlider);

        String[] modeNames = {
            "NONE",
            "SCREEN_DOOR",
            "BLENDED",
            "NICEST",
            "FASTEST"
        };
        int[] modeValues = {
            TransparencyAttributes.NONE,
            TransparencyAttributes.SCREEN_DOOR,
            TransparencyAttributes.BLENDED,
            TransparencyAttributes.NICEST,
            TransparencyAttributes.FASTEST
        };

        IntChooser modeChooser = new IntChooser("Mode:",
                modeNames, modeValues, mode);
        modeChooser.addIntListener(new IntListener() {
            public void intChanged(IntEvent event) {
                mode = event.getValue();
                transpAttr.setTransparencyMode(mode);
            }
        });
        add(modeChooser);

        String[] blendNames = {
            "BLEND_ZERO",
            "BLEND_ONE",
            "BLEND_SRC_ALPHA",
            "BLEND_ONE_MINUS_SRC_ALPHA"
        };
        int[] blendValues = {
            TransparencyAttributes.BLEND_ZERO,
            TransparencyAttributes.BLEND_ONE,
            TransparencyAttributes.BLEND_SRC_ALPHA,
            TransparencyAttributes.BLEND_ONE_MINUS_SRC_ALPHA,
        };
        IntChooser srcBlendFunctionChooser = new IntChooser("Src Blend Func:",
                blendNames, blendValues, srcBlendFunction);
        srcBlendFunctionChooser.addIntListener(new IntListener() {
            public void intChanged(IntEvent event) {
                srcBlendFunction = event.getValue();
                transpAttr.setSrcBlendFunction(srcBlendFunction);
            }
        });
        add(srcBlendFunctionChooser);
        IntChooser dstBlendFunctionChooser = new IntChooser("Dst Blend Func:",
                blendNames, blendValues, dstBlendFunction);
        dstBlendFunctionChooser.addIntListener(new IntListener() {
            public void intChanged(IntEvent event) {
                dstBlendFunction = event.getValue();
                transpAttr.setDstBlendFunction(dstBlendFunction);
            }
        });
        add(dstBlendFunctionChooser);
    }
}
