package j3d.utils;

/*
      @(#)RenderingAttributesEditor.java 1.2 01/08/01 11:02:23

***************************************************************
"Copyright (c) 2001 Sun Microsystems, Inc. All Rights Reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

-Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

-Redistribution in binary form must reproduce the above copyright notice, this
list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.

Neither the name of Sun Microsystems, Inc. or the names of contributors may be
used to endorse or promote products derived from this software without
specific prior written permission.

This software is provided "AS IS," without a warranty of any kind. ALL
EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

You acknowledge that Software is not designed,licensed or intended for use in
the design, construction, operation or maintenance of any nuclear facility."

****************************************************************************
*/

import gui.layouts.LeftAlignComponent;
import gui.run.*;

import javax.media.j3d.RenderingAttributes;
import javax.swing.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;


public class RenderingAttributesEditor extends JPanel
        implements Java3DExplorerConstants {

    // RenderingAttributes
    RenderingAttributes renderingAttr;
    boolean visible;
    boolean depthBufferEnable;
    boolean depthBufferWriteEnable;
    boolean ignoreVertexColors;
    boolean rasterOpEnable;
    int rasterOp;
    int alphaTestFunction;
    float alphaTestValue;

    public RenderingAttributesEditor(RenderingAttributes init) {
        renderingAttr = init;
        visible = renderingAttr.getVisible();
        depthBufferEnable = renderingAttr.getDepthBufferEnable();
        depthBufferWriteEnable = renderingAttr.getDepthBufferWriteEnable();
        ignoreVertexColors = renderingAttr.getIgnoreVertexColors();
        rasterOpEnable = renderingAttr.getRasterOpEnable();
        rasterOp = renderingAttr.getRasterOp();
        alphaTestFunction = renderingAttr.getAlphaTestFunction();
        alphaTestValue = renderingAttr.getAlphaTestValue();

        setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));

        JCheckBox visibleCheckBox =
                new JCheckBox("Visible", visible);
        visibleCheckBox.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JCheckBox checkbox = (JCheckBox) e.getSource();
                visible = checkbox.isSelected();
                renderingAttr.setVisible(visible);
            }
        });
        // add the checkbox to the panel
        add(new LeftAlignComponent(visibleCheckBox));

        JCheckBox ignoreVertexColorsCheckBox = new JCheckBox("Ignore Vertex Colors", ignoreVertexColors);
        ignoreVertexColorsCheckBox.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JCheckBox checkbox = (JCheckBox) e.getSource();
                ignoreVertexColors = checkbox.isSelected();
                renderingAttr.setIgnoreVertexColors(ignoreVertexColors);
            }
        });
        // add the checkbox to the panel
        add(new LeftAlignComponent(ignoreVertexColorsCheckBox));

        JCheckBox depthBufferEnableCheckBox =
                new JCheckBox("Depth Buffer Enable", depthBufferEnable);
        depthBufferEnableCheckBox.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JCheckBox checkbox = (JCheckBox) e.getSource();
                depthBufferEnable = checkbox.isSelected();
                renderingAttr.setDepthBufferEnable(depthBufferEnable);
            }
        });
        // add the checkbox to the panel
        add(new LeftAlignComponent(depthBufferEnableCheckBox));
        // no cap bit for depth buffer enable
        depthBufferEnableCheckBox.setEnabled(false);

        JCheckBox depthBufferWriteEnableCheckBox = new JCheckBox("Depth Buffer Write Enable", depthBufferWriteEnable);
        depthBufferWriteEnableCheckBox.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JCheckBox checkbox = (JCheckBox) e.getSource();
                depthBufferWriteEnable = checkbox.isSelected();
                renderingAttr.setDepthBufferWriteEnable(depthBufferWriteEnable);
            }
        });
        // add the checkbox to the panel
        add(new LeftAlignComponent(depthBufferWriteEnableCheckBox));
        // no cap bit for depth buffer enable
        depthBufferWriteEnableCheckBox.setEnabled(false);


        JCheckBox rasterOpEnableCheckBox = new JCheckBox("Raster Operation Enable", rasterOpEnable);
        rasterOpEnableCheckBox.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JCheckBox checkbox = (JCheckBox) e.getSource();
                rasterOpEnable = checkbox.isSelected();
                renderingAttr.setRasterOpEnable(rasterOpEnable);
            }
        });
        // add the checkbox to the panel
        add(new LeftAlignComponent(rasterOpEnableCheckBox));

        String[] rasterOpNames = {
            "ROP_COPY",
            "ROP_XOR",
        };
        int[] rasterOpValues = {
            RenderingAttributes.ROP_COPY,
            RenderingAttributes.ROP_XOR,
        };
        IntChooser rasterOpChooser = new IntChooser("Raster Operation:",
                rasterOpNames, rasterOpValues, rasterOp);
        rasterOpChooser.addIntListener(new IntListener() {
            public void intChanged(IntEvent event) {
                rasterOp = event.getValue();
                renderingAttr.setRasterOp(rasterOp);
            }
        });
        add(rasterOpChooser);

        String[] alphaTestFunctionNames = {
            "ALWAYS",
            "NEVER",
            "EQUAL",
            "NOT_EQUAL",
            "LESS",
            "LESS_OR_EQUAL",
            "GREATER",
            "GREATER_OR_EQUAL",
        };
        int[] alphaTestFunctionValues = {
            RenderingAttributes.ALWAYS,
            RenderingAttributes.NEVER,
            RenderingAttributes.EQUAL,
            RenderingAttributes.NOT_EQUAL,
            RenderingAttributes.LESS,
            RenderingAttributes.LESS_OR_EQUAL,
            RenderingAttributes.GREATER,
            RenderingAttributes.GREATER_OR_EQUAL,
        };
        IntChooser alphaTestFunctionChooser = new IntChooser("Alpha Test Function:", alphaTestFunctionNames,
                alphaTestFunctionValues, alphaTestFunction);
        alphaTestFunctionChooser.addIntListener(new IntListener() {
            public void intChanged(IntEvent event) {
                alphaTestFunction = event.getValue();
                renderingAttr.setAlphaTestFunction(alphaTestFunction);
            }
        });
        add(alphaTestFunctionChooser);

        FloatLabelJSlider alphaTestValueSlider = new FloatLabelJSlider("Alpha Test Value: ", 0.1f, 0.0f, 1.0f, alphaTestValue);
        alphaTestValueSlider.setMajorTickSpacing(1.0f);
        alphaTestValueSlider.setPaintTicks(true);
        alphaTestValueSlider.addFloatListener(new FloatListener() {
            public void floatChanged(FloatEvent e) {
                alphaTestValue = e.getValue();
                renderingAttr.setAlphaTestValue(alphaTestValue);
            }
        });
        add(alphaTestValueSlider);

    }
}
