package j3d.utils;

/*
      @(#)PolygonAttributesEditor.java 1.2 01/08/01 11:02:22

***************************************************************
"Copyright (c) 2001 Sun Microsystems, Inc. All Rights Reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

-Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

-Redistribution in binary form must reproduce the above copyright notice, this
list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.

Neither the name of Sun Microsystems, Inc. or the names of contributors may be
used to endorse or promote products derived from this software without
specific prior written permission.

This software is provided "AS IS," without a warranty of any kind. ALL
EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

You acknowledge that Software is not designed,licensed or intended for use in
the design, construction, operation or maintenance of any nuclear facility."

****************************************************************************
*/

import gui.layouts.LeftAlignComponent;
import gui.run.*;

import javax.media.j3d.PolygonAttributes;
import javax.swing.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;


public class PolygonAttributesEditor extends Box
        implements Java3DExplorerConstants {

    // PolygonAttributes
    PolygonAttributes polygonAttr;
    int polygonMode;
    int cullFace;
    float polygonOffset;
    float polygonOffsetFactor;
    boolean backFaceNormalFlip;

    public PolygonAttributesEditor(PolygonAttributes init) {
        super(BoxLayout.Y_AXIS);
        polygonAttr = init;
        polygonMode = polygonAttr.getPolygonMode();
        cullFace = polygonAttr.getCullFace();
        polygonOffset = polygonAttr.getPolygonOffset();
        polygonOffsetFactor = polygonAttr.getPolygonOffsetFactor();
        backFaceNormalFlip = polygonAttr.getBackFaceNormalFlip();

        String[] modeNames = {
            "POLYGON_POINT",
            "POLYGON_LINE",
            "POLYGON_FILL",
        };
        int[] modeValues = {
            PolygonAttributes.POLYGON_POINT,
            PolygonAttributes.POLYGON_LINE,
            PolygonAttributes.POLYGON_FILL,
        };
        IntChooser modeChooser = new IntChooser("Mode:",
                modeNames, modeValues, polygonMode);
        modeChooser.addIntListener(new IntListener() {
            public void intChanged(IntEvent event) {
                polygonMode = event.getValue();
                polygonAttr.setPolygonMode(polygonMode);
            }
        });
        add(modeChooser);

        String[] cullNames = {
            "CULL_NONE",
            "CULL_BACK",
            "CULL_FRONT",
        };
        int[] cullValues = {
            PolygonAttributes.CULL_NONE,
            PolygonAttributes.CULL_BACK,
            PolygonAttributes.CULL_FRONT,
        };
        IntChooser cullChooser = new IntChooser("Cull:",
                cullNames, cullValues, cullFace);
        cullChooser.addIntListener(new IntListener() {
            public void intChanged(IntEvent event) {
                cullFace = event.getValue();
                polygonAttr.setCullFace(cullFace);
            }
        });
        add(cullChooser);

        FloatLabelJSlider polygonOffsetSlider =
                new FloatLabelJSlider("Offset", 0.1f, 0.0f, 2.0f, polygonOffset);
        polygonOffsetSlider.setMajorTickSpacing(1.0f);
        polygonOffsetSlider.setPaintTicks(true);
        polygonOffsetSlider.addFloatListener(new FloatListener() {
            public void floatChanged(FloatEvent e) {
                polygonOffset = e.getValue();
                polygonAttr.setPolygonOffset(polygonOffset);
            }
        });
        add(polygonOffsetSlider);

        LogFloatLabelJSlider polygonOffsetFactorSlider =
                new LogFloatLabelJSlider("Offset Factor", 0.1f, 10000.0f,
                        polygonOffsetFactor);
        polygonOffsetFactorSlider.addFloatListener(new FloatListener() {
            public void floatChanged(FloatEvent e) {
                polygonOffsetFactor = e.getValue();
                polygonAttr.setPolygonOffsetFactor(polygonOffsetFactor);
            }
        });
        add(polygonOffsetFactorSlider);

        JCheckBox backFaceNormalFlipCheckBox =
                new JCheckBox("BackFaceNormalFlip", backFaceNormalFlip);
        backFaceNormalFlipCheckBox.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JCheckBox checkbox = (JCheckBox) e.getSource();
                backFaceNormalFlip = checkbox.isSelected();
                polygonAttr.setBackFaceNormalFlip(backFaceNormalFlip);
            }
        });
        // no ablity to change without replcing polygon attributes
        backFaceNormalFlipCheckBox.setEnabled(false);

        add(new LeftAlignComponent(backFaceNormalFlipCheckBox));
    }
}
