package j3d.utils;

/*
      @(#)Java3DExplorerConstants.java 1.3 01/08/01 11:02:16

***************************************************************
"Copyright (c) 2001 Sun Microsystems, Inc. All Rights Reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

-Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

-Redistribution in binary form must reproduce the above copyright notice, this
list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.

Neither the name of Sun Microsystems, Inc. or the names of contributors may be
used to endorse or promote products derived from this software without
specific prior written permission.

This software is provided "AS IS," without a warranty of any kind. ALL
EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

You acknowledge that Software is not designed,licensed or intended for use in
the design, construction, operation or maintenance of any nuclear facility."

****************************************************************************
*/

import javax.media.j3d.BoundingSphere;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import java.text.NumberFormat;

public interface Java3DExplorerConstants {

    // colors
    public static Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
    public static Color3f red = new Color3f(1.0f, 0.0f, 0.0f);
    public static Color3f green = new Color3f(0.0f, 1.0f, 0.0f);
    public static Color3f blue = new Color3f(0.0f, 0.0f, 1.0f);
    public static Color3f skyBlue = new Color3f(0.6f, 0.7f, 0.9f);
    public static Color3f cyan = new Color3f(0.0f, 1.0f, 1.0f);
    public static Color3f magenta = new Color3f(1.0f, 0.0f, 1.0f);
    public static Color3f yellow = new Color3f(1.0f, 1.0f, 0.0f);
    public static Color3f brightWhite = new Color3f(1.0f, 1.5f, 1.5f);
    public static Color3f white = new Color3f(1.0f, 1.0f, 1.0f);
    public static Color3f darkGrey = new Color3f(0.15f, 0.15f, 0.15f);
    public static Color3f medGrey = new Color3f(0.3f, 0.3f, 0.3f);
    public static Color3f grey = new Color3f(0.5f, 0.5f, 0.5f);
    public static Color3f lightGrey = new Color3f(0.75f, 0.75f, 0.75f);


    // infinite bounding region, used to make env nodes active everywhere
    BoundingSphere infiniteBounds = new BoundingSphere(new Point3d(),
            Double.MAX_VALUE);

    // common values
    static final String nicestString = "NICEST";
    static final String fastestString = "FASTEST";
    static final String antiAliasString = "Anti-Aliasing";
    static final String noneString = "NONE";

    // light type constants
    static int LIGHT_AMBIENT = 1;
    static int LIGHT_DIRECTIONAL = 2;
    static int LIGHT_POSITIONAL = 3;
    static int LIGHT_SPOT = 4;

    // screen capture constants
    static final int USE_COLOR = 1;
    static final int USE_BLACK_AND_WHITE = 2;

    // number formatter
    NumberFormat nf = NumberFormat.getInstance();

}
