package j3d.polyViewer.vec3;

/**
 * Simple 3d vector class with methods for simple operations. Used in torus
 * demo        G. Hart Sept 2003.
 */

public class Vec3 {
    public float x, y, z;

    Vec3(float x0, float y0, float z0) {            // constructor
        x = x0;
        y = y0;
        z = z0;
    }

    public Vec3(int x0, int y0, int z0) {           // constructor from ints
        x = (float) x0;
        y = (float) y0;
        z = (float) z0;
    }

    public String toString() {                     // "(x,y,z)" string form
        return "(" +
                Float.toString(this.x) +
                ","
                +
                Float.toString(this.y) +
                ","
                + Float.toString(this.z) + ")";
    }

    public static Vec3 plus(Vec3 a, Vec3 b) {         // sum
        return new Vec3(a.x + b.x, a.y + b.y, a.z + b.z);
    }

    public static Vec3 minus(Vec3 a, Vec3 b) {        // difference
        return new Vec3(a.x - b.x, a.y - b.y, a.z - b.z);
    }

    public static Vec3 scale(float a, Vec3 v) {      // scalar prod
        return new Vec3(a * v.x, a * v.y, a * v.z);
    }

    public static float dot(Vec3 a, Vec3 b) {        // dot prod
        return a.x * b.x + a.y * b.y + a.z * b.z;
    }

    public static float mag2(Vec3 a) {              // magnitude squared
        return a.x * a.x + a.y * a.y + a.z * a.z;
    }

    public static float mag(Vec3 a) {               // magnitude
        return (float) Math.sqrt(a.x * a.x + a.y * a.y + a.z * a.z);
    }

    public static Vec3 unit(Vec3 v) {                 // unit length
        return scale(1.0f / mag(v), v);                // we hope v isn't 0
    }

    public static Vec3 cross(Vec3 a, Vec3 b) {         // cross product
        return new Vec3(a.y * b.z - b.y * a.z,
                a.z * b.x - b.z * a.x,
                a.x * b.y - b.x * a.y);
    }

}