//Byron Kim
//CR325
package j3d.polyViewer.vec3;

public class ParabolicCylinder implements Vec3FunctionInterface {
    public static final double sqrt_2 = Math.sqrt(2);
    public static final double pi = Math.PI;
    public static final double twoPi = Math.PI * 2;

    public ParabolicCylinder() {

    }

    public Vec3 getPolarVec3(double r1,
                             double theta1,
                             double r2,
                             double theta2) {


        double x, y, z;

        x = scale(theta1/Math.PI, -r1*2, r1*2);

        y = scale(theta2/Math.PI, -r2*2, r2*2);

        z = scale(-x*x/2, -r1*r2, r1*r2);
        //double scale = twoPi * r2 * r2;
        //z = z * scale;
        return new Vec3(
                (float) x,
                (float) y,
                (float) z);

    }

    private double scale(double t, double tmin, double tmax) {
        t = (1 - t) * tmin + t * tmax;
        return t;
    }

    public static final double sin(double theta) {
        return Math.sin(theta);
    }

    public static final double cos(double theta) {
        return Math.cos(theta);
    }

    public String toString() {
        return getClass().getName();
    }
}
