/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package j3d.polyViewer.vec3;

import ip.transforms.Kernels;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 2, 2005
 * <p/>
 * Time: 4:02:56 AM
 */
public class LaplacianOfGauss implements Vec3FunctionInterface {
    public static final double sqrt_2 = Math.sqrt(2);
    public static final double pi = Math.PI;
    public static final double twoPi = Math.PI * 2;

    public LaplacianOfGauss() {

    }

    public Vec3 getPolarVec3(double r1,
                             double theta1,
                             double r2,
                             double theta2) {


        double x, y, z;

        x = scale(theta1 / twoPi, -r1, r1);

        y = scale(theta2 / twoPi, -r1, r1);
        try {
            //double zmax = Gauss.getMagnitudeOfTheDerivativeOfGauss(0,0,0,0,r2);
            z = Kernels.laplaceOfGaussian(x, y, 0, 0, r2);
            //double  scale =  twoPi * r2 * r2;
            // z = z * scale;
            z = z / 255;
            z = scale(z, -r1, r1);
        } catch (Exception e) {
            z = 0;

        }
        return new Vec3((float) x,
                (float) y,
                (float) z);

    }

    private double scale(double t, double tmin, double tmax) {
        t = (1 - t) * tmin + t * tmax;
        return t;
    }

    public static final double sin(double theta) {
        return Math.sin(theta);
    }

    public static final double cos(double theta) {
        return Math.cos(theta);
    }

    public String toString() {
        return getClass().getName();
    }
}
