package j3d.polyViewer.vec3;

/**
 * Created by IntelliJ IDEA.
 * User: Dave Pavlik
 * Date: Apr 11, 2005
 * Time: 5:48:34 PM
 */
public class Ellipsoid
        implements Vec3FunctionInterface {
    public Vec3 getPolarVec3(double r1,
                             double theta1,
                             double r2,
                             double theta2) {
        double r = Math.sqrt(r1 * r1 * r2 * r2 /
                (r1 * r1 * sin(theta1) * sin(theta1) +
                r2 * r2 * cos(theta1) * cos(theta1)));
        return new Vec3((float) (r * cos(theta1)),
                (float) (r * sin(theta1) * sin(theta2)),
                (float) (r * sin(theta1) * cos(theta2)));
    };

    private double sin(double theta){
        return Math.sin(theta);
    }

    private double cos(double theta){
        return Math.cos(theta);
    }
}
