package j3d.examples.shape.triangles.surfaces.geometries;

import j3d.examples.shape.triangles.surfaces.SurfaceGeometry;
import j3d.examples.shape.triangles.surfaces.SurfaceUniverse;

import javax.vecmath.Color3f;
import javax.vecmath.Vector3d;
import java.awt.*;

public class Sin extends SurfaceGeometry {

    public Sin(int strips, int stripLength, Color3f c1, Color3f c2) {
        super(strips, stripLength, c1, c2);
    }

    public Vector3d getViewingPosition() {
        return new Vector3d(2, 0, 6);
    }

    public static void main(String[] args) {
        new SurfaceUniverse("Sine",
                new Sin(5, 100,
                        new Color3f(Color.cyan), new Color3f(Color.blue)));
    }

    public double x(int strip, int index, int segment) {
        return 2 * radians(index) / Math.PI;
    }

    public double y(int strip, int index, int segment) {
        return Math.sin(2 * radians(index));
    }

    public double z(int strip, int index, int segment) {
        return -strip - segment;
    }

}