package j3d.examples.shape.triangles.surfaces;

import j3d.utils.sceneGraphBuilderUtils.ControlledUniverse;
import j3d.utils.sceneGraphBuilderUtils.SGBuilder;

import javax.media.j3d.BranchGroup;
import javax.media.j3d.Shape3D;

public class SurfaceUniverse extends ControlledUniverse {

    public SurfaceUniverse(String title, SurfaceGeometry g) {
        super(title, sceneGraph(title, g), plum);
        positionTheViewingPlatform(g.getViewingPosition());
    }

    public static BranchGroup sceneGraph(String title, SurfaceGeometry g) {
        BranchGroup figure = SGBuilder.newBranchGroup(title);

        // Use the same geometry in both shapes.
        figure.addChild(new Shape3D(g, SGBuilder.frontSurface()));
        figure.addChild(new Shape3D(g, SGBuilder.wireFrame()));

        return figure;
    }

}