/**********************************************************
Copyright (C) 2005, Michael N. Jacobs, All Rights Reserved

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

**************************************************************/
package j3d.examples.particles.shapes;
import javax.media.j3d.*;

public class PhantomFactory extends Shape3DFactory {
	
	public PhantomFactory(){
		this(5, 3);
	}
		
	public PhantomFactory(float aRadius, float aRadiusVariance){
		super(aRadius, aRadiusVariance);
	}
			
	protected Shape3D createShapeBasic(float aRadius) {
		Phantom aShape = new Phantom();
		aShape.setBoundsAutoCompute(false);
		BoundingSphere bs = new BoundingSphere();
		bs.setRadius(aRadius);
		aShape.setBounds(bs);
		return aShape;
	} 

}
