/**********************************************************
Copyright (C) 2005, Michael N. Jacobs, All Rights Reserved

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

**************************************************************/
package j3d.examples.particles.shapes;

import javax.media.j3d.*;
import javax.vecmath.*;

public class CloudPuffFactory extends Shape3DFactory {
	private int octaves, octavesVariance, noiseMode;
	private Color3f emissiveColor;
	private Color3f emissiveColorVariance;
	
	public CloudPuffFactory(){
		this(10, 2, new Color3f(0.5f, 0.5f, 0.5f), new Color3f(0.1f, 0.1f, 0.1f));
	}
	
	public CloudPuffFactory(float aRadius, float aRadiusVariance, Color3f anAmbientColor, Color3f aAmbientVariance){
		this(aRadius, aRadiusVariance, anAmbientColor, aAmbientVariance, 6, 1);
	}
	
	public CloudPuffFactory(float aRadius, float aRadiusVariance, Color3f anAmbientColor, Color3f aAmbientVariance, int octaves, int octaveVariance){
		this(aRadius, aRadiusVariance, anAmbientColor, aAmbientVariance, new Color3f(0.1f,0.1f,0.0f), new Color3f(0.05f,0.05f,0.00f), octaves, octaveVariance);
	}
	
	public CloudPuffFactory(float aRadius, float aRadiusVariance, Color3f anAmbientColor, Color3f aAmbientVariance, int octaves, int octaveVariance, int aMode){
		this(aRadius, aRadiusVariance, anAmbientColor, aAmbientVariance, new Color3f(0.1f,0.1f,0.0f), new Color3f(0.05f,0.05f,0.00f), octaves, octaveVariance, aMode);
	}
	
	public CloudPuffFactory(float aRadius, float aRadiusVariance, Color3f anAmbientColor, Color3f aAmbientVariance, Color3f anEmissiveColor, Color3f anEmissiveColorVariance, int octaves, int octaveVariance){
		this(aRadius, aRadiusVariance, anAmbientColor, aAmbientVariance, anEmissiveColor, anEmissiveColorVariance, octaves, octaveVariance, CloudPuff.CLOUDS);
	}
	
	public CloudPuffFactory(float aRadius, float aRadiusVariance, Color3f anAmbientColor, Color3f aAmbientVariance, Color3f anEmissiveColor, Color3f anEmissiveColorVariance, int octaves, int octaveVariance, int aMode){
		super(aRadius, aRadiusVariance, anAmbientColor, aAmbientVariance);
		emissiveColor = anEmissiveColor;
		emissiveColorVariance = anEmissiveColorVariance;
		this.octaves = octaves;
		this.octavesVariance = octaveVariance;
		noiseMode = aMode;
	}
		
	protected Shape3D createShapeBasic(float aRadius) {
		CloudPuff cp = new CloudPuff(aRadius,getEqualVaryingColor3f(), getVaryingEmissiveColor3f(), 0.5, getVaryingOctaves(), noiseMode);
		return cp;
	}
	
	protected int getVaryingOctaves(){	
		return octaves + Math.round(random() * octavesVariance);
	}
	
	protected Color3f getVaryingEmissiveColor3f() {
		float random = random();
		float red = emissiveColor.x + emissiveColorVariance.x * random;
		float green = emissiveColor.y + emissiveColorVariance.y * random;
		float blue = emissiveColor.z + emissiveColorVariance.z * random;
		red = clamp(red, 0, 1);
		green = clamp(green, 0, 1);
		blue = clamp(blue, 0, 1);

		return new Color3f(red, green, blue);
	}
	

	public Color3f getEmissiveColor() {
		return emissiveColor;
	}
	public void setEmissiveColor(Color3f emissiveColor) {
		this.emissiveColor = emissiveColor;
	}
	public Color3f getEmissiveColorVariance() {
		return emissiveColorVariance;
	}
	public void setEmissiveColorVariance(Color3f emissiveColorVariance) {
		this.emissiveColorVariance = emissiveColorVariance;
	}
	public int getNoiseMode() {
		return noiseMode;
	}
	public void setNoiseMode(int noiseMode) {
		this.noiseMode = noiseMode;
	}
	public int getOctaves() {
		return octaves;
	}
	public void setOctaves(int octaves) {
		this.octaves = octaves;
	}
	public int getOctavesVariance() {
		return octavesVariance;
	}
	public void setOctavesVariance(int octavesVariance) {
		this.octavesVariance = octavesVariance;
	}
}
