/**********************************************************
Copyright (C) 2005, Michael N. Jacobs, All Rights Reserved

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

**************************************************************/
package j3d.examples.particles.influences;

import java.util.*;

import j3d.examples.particles.emitters.*;

// TODO: Document the Scale constructors
public class Scale implements IExternalInfluence, IParticleLifeCycleListener {
	private ParticleAgeAlpha alpha;
	private float scale;
	private float base;
	
	public Scale(float aScale) {
		this(0, aScale);
	}
	
	public Scale(float aBase, float aScale) {
		this(aBase, aScale, new ParticleAgeAlpha(0,1,0,0));
	}
	
	public Scale(float aBase, float aScale, ParticleAgeAlpha anAlpha) {
		alpha = anAlpha;
		scale = aScale;
		base = aBase;
	}
	
	public void initializeParticle(Particle aParticle){
		// Nothing to do
	}
	
	public void apply(Particle aParticle, float dt) {
		float newSize = Math.max(base + scale * alpha.value(aParticle), 0.01f);
		aParticle.setScale(newSize);
	}

	public void aboutToDie(List c, float dt) {
		// Nothing to do
	}

	public void aboutToEmit(List aList, float dt) {
		int aSize = aList.size();
		for(int i = 0; i < aSize; i++){	
			Particle aParticle = (Particle)aList.get(i);
			aParticle.setScale(Math.max(base, 0.01f));
		}
	}

	public void updated(List c, float dt) {
		//  Nothing to do
	}

}
