/**********************************************************
Copyright (C) 2005, Michael N. Jacobs, All Rights Reserved

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

**************************************************************/
package j3d.examples.particles.influences;
import javax.vecmath.*;

import j3d.examples.particles.emitters.Particle;

/**
 * Represents a point in space that repulses (accelerates away)
 * particles from that point based on the distance between the
 * particle and the repulsing point.
 */
public class Repulse implements IExternalInfluence {
	private Point3f location;
	private Point3f particleLocation;
	private Vector3f acceleration;
	private float rate;
	 
	public Repulse(){
		this(50, new Point3f(0,0,0));
	}
	public Repulse(float aRate, Point3f aLocation){
		rate = aRate;
		location = aLocation;
		particleLocation = new Point3f();
		acceleration = new Vector3f();
	}
	
	public void initializeParticle(Particle aParticle){
		// Nothing to do
	}
	
	public void apply(Particle aParticle, float dt) {
		float [] world = aParticle.getWorldPosition();
		particleLocation.set(world);
		float distance2 = location.distanceSquared(particleLocation);
		float applied = rate/distance2;
		acceleration.sub(particleLocation, location);
		acceleration.normalize();
		acceleration.scale(applied);
		aParticle.addWorldAcceleration(acceleration);
	}

}
