/**********************************************************
Copyright (C) 2005, Michael N. Jacobs, All Rights Reserved

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

**************************************************************/
package j3d.examples.particles.influences;
import javax.vecmath.*;

import j3d.examples.particles.emitters.Particle;

/**
 * A directional gravity influence.  The direction 
 * and magnitude of the gravity is based on a vector.
 */
public class Gravity implements IExternalInfluence {
	private static float GRAVITY = 9.81f; // meters per second per second
	private Vector3f acceleration;
	private Vector3f workingCopy;
	
	/**
	 * Create a default gravity with an acceleration of
	 * 9.81 meters per second per second in a downward 
	 * direction.
	 */
	public Gravity(){
		this(new Vector3f(0, -GRAVITY, 0));
	}
	/**
	 * Create a gravity with an acceleration determined
	 * by the vector. 
	 */
	public Gravity(Vector3f anAcceleration){
		acceleration = anAcceleration;
		workingCopy = new Vector3f();
	}
	
	public void initializeParticle(Particle aParticle){
		// Nothing to do
	}
	
	public void apply(Particle aParticle, float dt) {
		workingCopy.set(acceleration);
		aParticle.addWorldAcceleration(workingCopy);
	}

}
