/**********************************************************
Copyright (C) 2005, Michael N. Jacobs, All Rights Reserved

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

**************************************************************/
package j3d.examples.particles.generationshapes;
import j3d.examples.particles.emitters.*;

import javax.vecmath.*;

/**
 * Emits particles from a single point.  The particles are emitted 
 * in the direction of positive y-axis.  Particles are spread radially
 * based on the spread angle (in all directions away from the point).
 * The spread angle is the number of radians from the y-axis to the 
 * edge of the emitting cone of particles (similar to a spot light).
 */
public class PointGenerationShape
	extends GenerationShape
	implements IGenerationShape {

	public PointGenerationShape(float spreadAngle) {
		super(spreadAngle);
	}
	
	public PointGenerationShape(double spreadAngle) {
		super(spreadAngle);
	}
	
	public void initializeParticlePosition(Particle particle) {
		particle.setInitialLocalPosition(0f, 0f, 0f);
	}

	public void initializeParticleVelocity(Particle particle) {
		// local velocity
		Vector3f velocity = new Vector3f();
		velocity.set(
			getVaryingParticleVelocity() * random() * getSpread(),
			getVaryingParticleVelocity(),
			getVaryingParticleVelocity() * random() * getSpread());
		particle.setLocalVelocity(velocity);

	}

}
