/**********************************************************
Copyright (C) 2005, Michael N. Jacobs, All Rights Reserved

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

**************************************************************/
package j3d.examples.particles.generationshapes;
import j3d.examples.particles.emitters.*;
/**
 * Base class for all particle generation shapes.
 */
public abstract class GenerationShape {
	private float spread;
	private ParticleEmitter emitter;
	
	protected GenerationShape(){
		
	}
	/**
	 * Default constructor to set up the nozzle for particle emission.
	 * @param spreadAngle - The angle (in radians) defining the edges of
	 * the inverted cone within which particles are to be emitted.
	 */
	protected GenerationShape(float spreadAngle){
		spread = (float) Math.sin(spreadAngle / 2);
	}
	
	protected GenerationShape(double spreadAngle){
		this((float) spreadAngle);
	}
	
	protected float getSpread() {
		return spread;
	}
	
	protected float getVaryingParticleVelocity(){
		return emitter.getVaryingParticleVelocity();
	}
	
	protected float random(){
		return emitter.random();
	}
	
	public ParticleEmitter getEmitter() {
		return emitter;
	}

	public void setEmitter(ParticleEmitter emitter) {
		this.emitter = emitter;
	}

}
