/**********************************************************
Copyright (C) 2005, Michael N. Jacobs, All Rights Reserved

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

**************************************************************/
package j3d.examples.particles.examples;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.GraphicsConfiguration;

import javax.media.j3d.*;
import javax.vecmath.*;

import j3d.examples.particles.*;
import j3d.examples.particles.emitters.*;
import j3d.examples.particles.generationshapes.*;
import j3d.examples.particles.influences.*;
import j3d.examples.particles.shapes.*;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.keyboard.KeyNavigatorBehavior;
import com.sun.j3d.utils.universe.SimpleUniverse;
// TODO: Add wind to SmokeParticleSystem example
public class SmokeParticleSystemExample extends Applet {

	public static void main(String[] args) {
		new MainFrame(new SmokeParticleSystemExample(), 800, 800);
	}
	
	public SmokeParticleSystemExample() {
		initialize();
	}
	
	public BranchGroup createSceneGraph(SimpleUniverse su) {
		BranchGroup objRoot = new BranchGroup();
		
		XZPlane plane = new XZPlane(5, 10);
		objRoot.addChild(plane);
		
		ParticleEmitter pe =  new ParticleEmitter(
						new DiskGenerationShape((float)Math.PI/8, 2.5f, 2.5f),
						5.2f, 	// emission rate
						2.0f, 	// emission rate variance
						1.9f, 	// velocity
						0.3f, 	// velocity variance
						4.0f, 	// lifetime
						2.0f,	// lifetime variance
						1500	// emitter lifetime in seconds
						);

		pe.addInfluence(new FadeShape());
		pe.addInfluence(new Scale(3));
		CloudPuffFactory factory = new CloudPuffFactory();
		factory.setNoiseMode(CloudPuff.SMOKE);
		Shape3DParticleSystem particleSystem = new Shape3DParticleSystem(pe, factory);
		
		TransformGroup psGroup = new TransformGroup();
		Transform3D t3d = new Transform3D();
		t3d.setTranslation(new Vector3f(0, 5, 0));
		psGroup.setTransform(t3d);
		psGroup.addChild(particleSystem);
		objRoot.addChild(psGroup);

		BoundingSphere bounds = new BoundingSphere();
		bounds.setRadius(300);
		
		AmbientLight ambient = new AmbientLight();
		ambient.setColor(new Color3f(1f, 1f, 1f));
		ambient.setInfluencingBounds(bounds);
		objRoot.addChild(ambient);

		// Add a directional light
		DirectionalLight directional = new DirectionalLight();
		directional.setDirection(1.0f, -0.4f, 1f);
		directional.setColor(new Color3f(0.7f, 0.7f, 0.7f));
		directional.setInfluencingBounds(bounds);
		objRoot.addChild(directional);		

		// Add a behavior to manage the particle system animation
		ParticleSystemManager manager = ParticleSystemManager.getCurrent();
		manager.setSchedulingBounds(bounds);
		objRoot.addChild(manager);
		
		// Add a keyboard navigator to move around
		TransformGroup vpTrans =
			su.getViewingPlatform().getViewPlatformTransform();
		KeyNavigatorBehavior keyNavBeh =
			new KeyNavigatorBehavior(vpTrans);
		keyNavBeh.setSchedulingBounds(bounds);
		objRoot.addChild(keyNavBeh);

		// Optimize the scene graph
		objRoot.compile();
		return objRoot;
	}
	private void initialize() {
		setLayout(new BorderLayout());
		GraphicsConfiguration config =
			SimpleUniverse.getPreferredConfiguration();
		Canvas3D canvas3D = new Canvas3D(config);
		add("Center", canvas3D);
		SimpleUniverse simpleU = new SimpleUniverse(canvas3D);
		
		//Position the view
		TransformGroup viewingPlatformGroup =
			simpleU.getViewingPlatform().getViewPlatformTransform();
		Transform3D t3d = new Transform3D();
		t3d.setTranslation(new Vector3f(0, 15, 60));
		viewingPlatformGroup.setTransform(t3d);

		BranchGroup scene = createSceneGraph(simpleU);
		simpleU.addBranchGraph(scene);

		canvas3D.getView().setBackClipDistance(300.0d);
		canvas3D.getView().setFrontClipDistance(0.1d);
		canvas3D.getView().setMinimumFrameCycleTime(20);
		canvas3D.getView().setTransparencySortingPolicy(View.TRANSPARENCY_SORT_GEOMETRY);
	}

}
