/**********************************************************
Copyright (C) 2005, Michael N. Jacobs, All Rights Reserved

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

**************************************************************/
package j3d.examples.particles.examples;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.GraphicsConfiguration;

import javax.media.j3d.*;
import javax.vecmath.*;

import j3d.examples.particles.*;
import j3d.examples.particles.emitters.*;
import j3d.examples.particles.influences.*;
import j3d.examples.particles.generationshapes.*;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.keyboard.KeyNavigatorBehavior;
import com.sun.j3d.utils.universe.SimpleUniverse;

public class MotionBlurredParticleSystemExample extends Applet {

	public static void main(String[] args) {
		new MainFrame(new MotionBlurredParticleSystemExample(), 600, 600);
	}
	
	public MotionBlurredParticleSystemExample() {
		initialize();
	}

	public BranchGroup createSceneGraph(SimpleUniverse su) {
		BranchGroup objRoot = new BranchGroup();
		objRoot.addChild(new XZPlane(10, 30));
		
		IExternalInfluence gravity = new Gravity();
		IExternalInfluence bounce = new Bounce();
		
		// Add a behavior to manage the particle system animation
		BoundingSphere bounds = new BoundingSphere();
		bounds.setRadius(1000);
		ParticleSystemManager manager = ParticleSystemManager.getCurrent(0.1f);
		manager.setSchedulingBounds(bounds);
		objRoot.addChild(manager);
		
		TransformGroup diskTG = new TransformGroup();
		Transform3D diskTransform = new Transform3D();
		diskTransform.rotZ(-Math.PI/8);
		diskTransform.setTranslation(new Vector3f(0, 10, 0));
		diskTG.setTransform(diskTransform);
		ParticleEmitter diskEmitter = useDiskEmitter();
		diskEmitter.addInfluence(gravity);
		diskEmitter.addInfluence(bounce);
		ParticleSystem diskParticleSystem = new MotionBlurredParticleSystem(diskEmitter, new Color3f(1,1,0),new Color3f(1,0.5f,0));
		diskTG.addChild(diskParticleSystem);
		objRoot.addChild(diskTG);

		TransformGroup pointTG = new TransformGroup();
		Transform3D pointTransform = new Transform3D();
		pointTransform.setTranslation(new Vector3f(-50, 0, -40));
		pointTG.setTransform(pointTransform);
		ParticleEmitter pointEmitter = usePointEmitter();
		pointEmitter.addInfluence(gravity);
		pointEmitter.addInfluence(bounce);
		ParticleSystem pointParticleSystem = new MotionBlurredParticleSystem(pointEmitter, new Color3f(1,0,0),new Color3f(1,1,0));
		pointTG.addChild(pointParticleSystem);
		objRoot.addChild(pointTG);
		
		TransformGroup lineTG = new TransformGroup();
		Transform3D lineTransform = new Transform3D();
		lineTransform.rotX(0.8*Math.PI/2);
		lineTransform.setTranslation(new Vector3f(0, 30, -80));
		lineTG.setTransform(lineTransform);
		ParticleEmitter lineEmitter = useLineEmitter();
		lineEmitter.addInfluence(gravity);
		lineEmitter.addInfluence(bounce);
		ParticleSystem lineParticleSystem = new MotionBlurredParticleSystem(lineEmitter, new Color3f(0,1,1),new Color3f(0,0,0));
		lineTG.addChild(lineParticleSystem);
		objRoot.addChild(lineTG);

//		FrameRateBehavior fps = new FrameRateBehavior();
//		fps.setSchedulingBounds(bounds);
//		objRoot.addChild(fps);

		AmbientLight ambient = new AmbientLight();
		ambient.setColor(new Color3f(1f, 1f, 1f));
		ambient.setInfluencingBounds(bounds);
		objRoot.addChild(ambient);

		// Add a directional light
		DirectionalLight directional = new DirectionalLight();
		directional.setDirection(1.0f, -0.4f, 1f);
		directional.setColor(new Color3f(0.7f, 0.7f, 0.7f));
		directional.setInfluencingBounds(bounds);
		objRoot.addChild(directional);
			
		// Add a keyboard navigator to move around
		TransformGroup vpTrans =
			su.getViewingPlatform().getViewPlatformTransform();
		KeyNavigatorBehavior keyNavBeh =
			new KeyNavigatorBehavior(vpTrans);
		keyNavBeh.setSchedulingBounds(bounds);
		objRoot.addChild(keyNavBeh);

		// Optimize the scene graph
		objRoot.compile();
		return objRoot;
	}
	private void initialize() {
		setLayout(new BorderLayout());
		GraphicsConfiguration config =
			SimpleUniverse.getPreferredConfiguration();
		Canvas3D canvas3D = new Canvas3D(config);
		add("Center", canvas3D);
		SimpleUniverse simpleU = new SimpleUniverse(canvas3D);
		
		//Position the view
		TransformGroup viewingPlatformGroup =
			simpleU.getViewingPlatform().getViewPlatformTransform();
		Transform3D t3d = new Transform3D();
		t3d.setTranslation(new Vector3f(0, 0, 60));
		viewingPlatformGroup.setTransform(t3d);

		BranchGroup scene = createSceneGraph(simpleU);
		simpleU.addBranchGraph(scene);

		canvas3D.getView().setBackClipDistance(300.0d);
		canvas3D.getView().setFrontClipDistance(0.1d);
		canvas3D.getView().setMinimumFrameCycleTime(20);
	}
	private ParticleEmitter useDiskEmitter(){
		return new ParticleEmitter(
					new DiskGenerationShape(Math.PI/8,10,2),
					500, 	// emission rate
					40, 	// emission rate variance
					15, 	// velocity
					1.5f, 	// velocity variance
					5, 		// lifetime
					1.5f,	// lifetime variance
					3000,	// emitter lifetime in seconds
					true);
	}
	
	private ParticleEmitter useLineEmitter(){
		return new ParticleEmitter(
					new LineGenerationShape(Math.PI/10,20),
					400, 	// emission rate
					0, 		// emission rate variance
					8, 		// velocity
					2, 		// velocity variance
					5, 		// lifetime
					0.5f,	// lifetime variance
					3000,	// emitter lifetime in seconds
					true);
	}
	
	private ParticleEmitter usePointEmitter(){
		return new ParticleEmitter(
					new PointGenerationShape(Math.PI/8),
					400, 	// emission rate
					50, 	// emission rate variance
					20, 	// velocity
					4, 		// velocity variance
					5, 		// lifetime
					1.5f,	// lifetime variance
					3000,	// emitter lifetime in seconds
					true);
	}

}
