/**********************************************************
Copyright (C) 2005, Michael N. Jacobs, All Rights Reserved

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

**************************************************************/
package j3d.examples.particles.examples;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.GraphicsConfiguration;

import javax.media.j3d.*;
import javax.vecmath.*;

import j3d.examples.particles.*;
import j3d.examples.particles.emitters.*;
import j3d.examples.particles.generationshapes.*;
import j3d.examples.particles.influences.*;
import j3d.examples.particles.shapes.*;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.keyboard.KeyNavigatorBehavior;
import com.sun.j3d.utils.universe.SimpleUniverse;

public class ColorCubeParticleSystemExample extends Applet {

	public static void main(String[] args) {
		new MainFrame(new ColorCubeParticleSystemExample(false), 600, 600);
	}
	private Canvas3D canvas3D;
	private boolean recording;
	
	public ColorCubeParticleSystemExample(boolean recording) {
		this.recording = recording;
		initialize();
	}
	
	public BranchGroup createSceneGraph(SimpleUniverse su) {
		BranchGroup objRoot = new BranchGroup();
		
		XZPlane plane = new XZPlane(5, 10); // 50 by 50 
		objRoot.addChild(plane);
		float rate = (float) Math.PI/2;
		Vector3f particleRotationRate = new Vector3f(rate, rate, rate);
		Vector3f particleRotationRateVariance = new Vector3f(rate/2, rate/3, rate/4);
		//Vector3f particleRotationRateVariance = new Vector3f(0, 0, 0);

		ParticleEmitter pe =  new ParticleEmitter(
						new DiskGenerationShape((float)Math.PI/8, 2.5f, 1.5f),
						3.5f, 	// emission rate
						1.0f, 	// emission rate variance
						22f, 	// velocity
						5f, 	// velocity variance
						particleRotationRate,
						particleRotationRateVariance,
						12.5f, 	// lifetime
						1.5f,	// lifetime variance
						120		// emitter lifetime in seconds
						);
		pe.addInfluence(new Gravity());
		// Bounce on the XY Plane, but let the cubes fall  
		// to the abyss if outside of the bounce bounds.
		pe.addInfluence(new BounceShape(new BoundingBox(new Point3d(-25, -100, -25), new Point3d(25, 0, 25))));
		pe.addInfluence(new FadeShape(new ParticleAgeAlpha(0,0,0.95f,0.05f)));

		IShape3DFactory factory = new ColorCubeFactory();			
		Shape3DParticleSystem particleSystem = new Shape3DParticleSystem(pe, factory);

		TransformGroup psGroup = new TransformGroup();
		Transform3D t3d = new Transform3D();
		t3d.setTranslation(new Vector3f(0, 5, 0));
		psGroup.setTransform(t3d);
		psGroup.addChild(particleSystem);
		objRoot.addChild(psGroup);

		BoundingSphere bounds = new BoundingSphere();
		bounds.setRadius(200);
//		FrameRateBehavior fps = new FrameRateBehavior();
//		fps.setSchedulingBounds(bounds);
//		objRoot.addChild(fps);
		
		AmbientLight ambient = new AmbientLight();
		ambient.setColor(new Color3f(1f, 1f, 1f));
		ambient.setInfluencingBounds(bounds);
		objRoot.addChild(ambient);

		// Add a directional light
		DirectionalLight directional = new DirectionalLight();
		directional.setDirection(1.0f, -0.4f, 1f);
		directional.setColor(new Color3f(0.7f, 0.7f, 0.7f));
		directional.setInfluencingBounds(bounds);
		objRoot.addChild(directional);		

		// Add a behavior to manage the particle system animation
		ParticleSystemManager manager = ParticleSystemManager.getCurrent();
		manager.setSchedulingBounds(bounds);
		objRoot.addChild(manager);
		
		// Add a keyboard navigator to move around
		TransformGroup vpTrans =
			su.getViewingPlatform().getViewPlatformTransform();
		KeyNavigatorBehavior keyNavBeh =
			new KeyNavigatorBehavior(vpTrans);
		keyNavBeh.setSchedulingBounds(bounds);
		objRoot.addChild(keyNavBeh);
		
		if(recording){
			ImageCaptureBehavior capture = new ImageCaptureBehavior(canvas3D, 0);
			capture.setSchedulingBounds(bounds);
			objRoot.addChild(capture);
		}
		
		// Optimize the scene graph
		objRoot.compile();
		return objRoot;
	}
	private void initialize() {
		setLayout(new BorderLayout());
		GraphicsConfiguration config =
			SimpleUniverse.getPreferredConfiguration();
		canvas3D = new Canvas3D(config);
		add("Center", canvas3D);
		SimpleUniverse simpleU = new SimpleUniverse(canvas3D);
		
		//Position the view
		TransformGroup viewingPlatformGroup =
			simpleU.getViewingPlatform().getViewPlatformTransform();
		Transform3D t3d = new Transform3D();
		t3d.setTranslation(new Vector3f(0, 15, 90));
		viewingPlatformGroup.setTransform(t3d);

		BranchGroup scene = createSceneGraph(simpleU);
		simpleU.addBranchGraph(scene);

		canvas3D.getView().setBackClipDistance(300.0d);
		canvas3D.getView().setFrontClipDistance(0.1d);
		canvas3D.getView().setMinimumFrameCycleTime(20);	
		canvas3D.getView().setTransparencySortingPolicy(View.TRANSPARENCY_SORT_GEOMETRY);	
	}

}
