/**
 * WriteGIF is a class that takes an Image and saves it to
 * a GIF format file.
 *
 * Based upon gifsave.c, which was written and released by
 * Sverre H. Huseby. Ported to Java by Adam Doppelt of Brown
 * University.
 * Modified and integrated with the ImageProc program for
 * CS411X, advanced Java Programming at the University of
 * Bridgeport by Victor Silva
 * Modified again by D. Lyon 7/8/01
 *
 */
package j2d.io.gif.stills;

import java.awt.*;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class WriteGIF {
    short width_, height_;
    int numColors_;
    byte pixels_[], colors_[];

    ScreenDescriptor sd_;
    ImageDescriptor id_;

    public static void toFile(java.awt.Image img, String fname) {
        // encode the image as a GIF
        try {
            WriteGIF wg = new WriteGIF(img);
            wg.toOutputStream(
                    new java.io.BufferedOutputStream(
                            new FileOutputStream(fname))
            );
        } catch (Exception e) {
            System.out.println("Save GIF Exception!");
        }
    }

    public WriteGIF(java.awt.Image image) throws java.awt.AWTException {
        width_ = (short) image.getWidth(null);
        height_ = (short) image.getHeight(null);

        int values[] = new int[width_ * height_];
        java.awt.image.PixelGrabber grabber = new java.awt.image.PixelGrabber(
                image, 0, 0, width_, height_, values, 0, width_);

        try {
            if (grabber.grabPixels() != true)
                throw new java.awt.AWTException("Grabber returned false: " +
                        grabber.status());
        } catch (InterruptedException e) {
        }
        ;

        //--------------------------------------------------------------
        // TODO -> Possible Speed up - do it a row at a time, a la ACME
        //--------------------------------------------------------------
        byte r[][] = new byte[width_][height_];
        byte g[][] = new byte[width_][height_];
        byte b[][] = new byte[width_][height_];
        int index = 0;

        for (int y = 0; y < height_; ++y) {
            for (int x = 0; x < width_; ++x) {
                r[x][y] = (byte) ((values[index] >> 16) & 0xFF);
                g[x][y] = (byte) ((values[index] >> 8) & 0xFF);
                b[x][y] = (byte) ((values[index]) & 0xFF);
                ++index;
            }
        }
        toIndexedColor(r, g, b);
    }


    public void toOutputStream(java.io.OutputStream os)
            throws java.io.IOException {
        BitUtils.writeString(os, "GIF87a");
        ScreenDescriptor sd =
                new ScreenDescriptor(
                        width_, height_, numColors_);
        sd.write(os);
        os.write(colors_, 0, colors_.length);
        ImageDescriptor id =
                new ImageDescriptor(width_, height_, ',');
        id.write(os);

        byte codesize = BitUtils.bitsNeeded(numColors_);
        if (codesize == 1) ++codesize;

        os.write(codesize);

        LZWCompressor.compress(os, codesize, pixels_);
        os.write(0);

        id = new ImageDescriptor((byte) 0, (byte) 0, ';');
        id.write(os);
        os.flush();
    }

    void toIndexedColor(byte r[][], byte g[][], byte b[][])
            throws java.awt.AWTException {
        pixels_ = new byte[width_ * height_];
        colors_ = new byte[256 * 3];
        int colornum = 0;
        for (int x = 0; x < width_; ++x) {
            for (int y = 0; y < height_; ++y) {
                int search;
                for (search = 0; search < colornum; ++search) {
                    if (colors_[search * 3] == r[x][y] &&
                            colors_[search * 3 + 1] == g[x][y] &&
                            colors_[search * 3 + 2] == b[x][y]) {
                        break;
                    }
                }

                // If there are more than 256 colors invoke
                // the color quantization procedure.
                //quantization();
                if (search > 255) {
                    throw new java.awt.AWTException("Too many colors.");
                }

                pixels_[y * width_ + x] = (byte) search;

                if (search == colornum) {
                    colors_[search * 3] = r[x][y];
                    colors_[search * 3 + 1] = g[x][y];
                    colors_[search * 3 + 2] = b[x][y];
                    ++colornum;
                }
            }
        }
        numColors_ = 1 << BitUtils.bitsNeeded(colornum);
        byte copy[] = new byte[numColors_ * 3];
        System.arraycopy(colors_, 0, copy, 0, numColors_ * 3);
        colors_ = copy;
    }

    public static void doIt(Image img, String fname)
            throws IOException, AWTException {
        // encode the image as a GIF
        WriteGIF encode = new WriteGIF(img);

        OutputStream output = new BufferedOutputStream(
                new FileOutputStream(fname));
        encode.toOutputStream(output);

    }
}

