/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package j2d.io.gif.stills;

public class BitUtils {
    public static byte bitsNeeded(int n) {
        byte ret = 1;

        if (n-- == 0) return 0;

        while ((n >>= 1) != 0)
            ++ret;

        return ret;
    }

    public static void writeWord(
            java.io.OutputStream os, short w)
            throws java.io.IOException {
        os.write(w & 0xFF);
        os.write((w >> 8) & 0xFF);
    }

   public static void writeString(
            java.io.OutputStream os, String string)
            throws java.io.IOException {
        for (int i = 0; i < string.length(); ++i)
            os.write((byte) (string.charAt(i)));
    }
}
