package j2d.edge;

import ip.transforms.Kernels;
import j2d.ImageProcessorFactory;
import j2d.ImageProcessorInterface;
import j2d.ImageUtils;
import j2d.hpp.InvertFilter;
import j2d.hpp.ThresholdProcessor;

import java.awt.*;


public class MehrotraAndZhangProcessor
        implements ImageProcessorInterface,
        ImageProcessorFactory {

    private int kernelWidth;
    private double h;


    public MehrotraAndZhangProcessor(
            int _kernelWidth,
            double _h) {

        kernelWidth = _kernelWidth;
        h = _h;
    }

    public ImageProcessorInterface getProcessor(int i) {
        return
                new MehrotraAndZhangProcessor(
                        kernelWidth,
                        i);
    }

    public Image process(Image img) {
        return MehrotraAndZhang(img);

    }

    private Image MehrotraAndZhang(Image img) {
        System.out.println(
                "kw=" + kernelWidth +
                " h=" + h);
        ThresholdProcessor thresh = new ThresholdProcessor(128);
        ImageProcessorInterface invert = InvertFilter.getProcessor();
        Image mzImage = ImageUtils.convolution(img,
                Kernels.getMehrotraAndZhangKernel(
                        kernelWidth,
                        kernelWidth,
                        h));

        mzImage = thresh.process(mzImage);
        mzImage = ImageUtils.convolution(
                mzImage,
                Kernels.getSobel());


        return invert.process(mzImage);
    }

}

