package j2d.edge;

import ip.transforms.Kernels;
import j2d.ImageProcessorFactory;
import j2d.ImageProcessorInterface;
import j2d.ImageUtils;
import j2d.hpp.InvertFilter;

import java.awt.*;


public class LoGProcessor
        implements ImageProcessorInterface,
        ImageProcessorFactory {

    private int kernelWidth;
    private double sigma;


    public LoGProcessor(
            int _kernelWidth,
            double _sigma) {

        kernelWidth = _kernelWidth;
        sigma = _sigma;
    }

    public ImageProcessorInterface getProcessor(int i) {
        return
                new LoGProcessor(
                        kernelWidth,
                        i + 1);
    }

    public Image process(Image img) {
        return LoGSobel(img);

    }


    private Image LoGSobel(Image img) {
        System.out.println(
                "kw=" + kernelWidth +
                " sigma=" + sigma);
        ImageProcessorInterface invert = InvertFilter.getProcessor();
        Image logImage = ImageUtils.convolution(img,
                Kernels.getLaplaceOfGaussianKernel(
                        kernelWidth,
                        kernelWidth,
                        sigma));
        return
                invert.process(logImage);
    }

}

