/*
 * Created by DocJava, Inc.
 * User: lyon
 * Date: Mar 2, 2003
 * Time: 5:12:56 PM
 */
package j2d.color;

import gui.run.RunButton;
import gui.run.RunSlider;
import j2d.ImageProcessListener;

import javax.swing.*;
import java.awt.*;


public class ColorSpacePanel
        extends JPanel {

    private ImageProcessListener ipl = null;

    private RunSlider rsa[][] = new RunSlider[3][3];
    private float colorMatrix[][] = new float[3][3];


    public ColorSpacePanel(ImageProcessListener _ipl) {
        ipl = _ipl;

        setLayout(new GridLayout(0, 3));
        for (int x = 0; x < rsa.length; x++)
            for (int y = 0; y < rsa[0].length; y++)
                add(new FloatMatrixSlider(x, y));
        add(getButtonPanel());
    }

    private JPanel getButtonPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new FlowLayout());
        jp.add(new RunButton("apply") {
            public void run() {
                updateImage();
            }
        });
        jp.add(new RunButton("Reset") {
            public void run() {
                ipl.update(null);
            }
        });
        return jp;
    }

    private void updateImage() {
        ipl.update(new ColorSpaceProcessor(colorMatrix));

    }

    public static float scaleSlider(int t) {
        return (float) (t / 100.0);
    }

    private class FloatMatrixSlider extends RunSlider {
        private final int x;
        private final int y;

        public FloatMatrixSlider(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public void run() {
            colorMatrix[x][y] =
                    scaleSlider(getValue());
            updateImage();
        }
    }
}
