package j2d.border;

import j2d.ImageProcessorInterface;
import j2d.ImageUtils;

import javax.media.jai.PlanarImage;
import java.awt.*;


/**
 * Created by IntelliJ IDEA.
 * User: Dahiana M
 * Date: Mar 23, 2005
 * Time: 8:17:14 PM
 * To change this template use File | Settings | File Templates.
 */
public class BorderProcessor implements
        ImageProcessorInterface {
    private int topValue = 0;
    private int bottomValue = 0;
    private int leftValue = 0;
    private int rightValue = 0;
    private int borderType = 0;

    public BorderProcessor(int top,
                                int bottom,
                                int left,
                                int right,
                                int border) {
        topValue = top;
        bottomValue = bottom;
        leftValue = left;
        rightValue = right;
        borderType = border;
    }


    public Image process(Image img) {
        img = ImageUtils.getBufferedImage(img);
        PlanarImage image = ImageUtils.getPlanarImage(img);

        // Create a ParameterBlock for the border operation.
        PlanarImage borderImage = Utils.getBorderImage(image, //I changed Utils.getBorderImage as an Object
                leftValue,
                rightValue,
                topValue,
                bottomValue,
                borderType);

        return ImageUtils.getImage(borderImage.getAsBufferedImage());

    }


}
