package ip.transforms;

import math.Mat2;


public final class Kernels {
    private Kernels() {
    }

    private static double robinsonScaleFactor = .25;

    // Robinson level 5 detector, see Pratt.
    public static float[][] getRobinson1() {
        float k[][] = {
            {(float) 1, 0, -1},
            {(float) 2, 0, -2},
            {(float) 1, 0, -1}
        };
        Mat2.scale(k, robinsonScaleFactor);
        return k;
    }

    public static float[][] getRobinson2() {
        float k[][] = {
            {(float) 0, -1, -2},
            {(float) 1, 0, -1},
            {(float) 2, 1, 0}
        };
        Mat2.scale(k, robinsonScaleFactor);
        return k;
    }

    public static float[][] getSobel() {
        float k[][] = {
            {(float) -1, -1, -1},
            {(float) -1, 8, -1},
            {(float) -1, -1, -1}
        };
        return k;
    }

    public static float[][] getSobelX(int a) {
        float k[][] = {
            {(float) -1, 0, 1},
            {(float) -a, 0, a},
            {(float) -1, 0, 1}
        };
        return k;
    }

    public static float[][] getSobelY(int a) {
        float k[][] = {
            {(float) -1, -a, 1},
            {(float) 0, 0, 0},
            {(float) 1, a, 1}
        };
        return k;
    }


    public static float[][] getRobinson3() {
        float k[][] = {
            {(float) -1, -2, -1},
            {(float) 0, 0, 0},
            {(float) 1, 2, 1}
        };
        Mat2.scale(k, robinsonScaleFactor);
        return k;
    }

    public static float[][] getRobinson4() {
        float k[][] = {
            {(float) -2, -1, 0},
            {(float) -1, 0, 1},
            {(float) 0, 1, 2}
        };
        Mat2.scale(k, robinsonScaleFactor);
        return k;
    }

    public static float[][] getRobinson5() {
        float k[][] = {
            {(float) -1, 0, 1},
            {(float) -2, 0, 2},
            {(float) -1, 0, 1}
        };
        Mat2.scale(k, robinsonScaleFactor);
        return k;
    }

    public static float[][] getRobinson6() {
        float k[][] = {
            {(float) 0, 1, 2},
            {(float) -1, 0, 1},
            {(float) -2, -1, 0}
        };
        Mat2.scale(k, 0.25);
        return k;
    }

    public static float[][] getRobinson7() {
        float k[][] = {
            {(float) 1, 2, 1},
            {(float) 0, 0, 0},
            {(float) -1, -2, -1}
        };
        Mat2.scale(k, robinsonScaleFactor);
        return k;
    }

    public static float[][] getRobinson8() {
        float k[][] = {
            {(float) 2, 1, 0},
            {(float) 1, 0, -1},
            {(float) 0, -1, -2}
        };
        Mat2.scale(k, robinsonScaleFactor);
        return k;
    }


    public static short[][] getMedian2x1() {
        short k[][] = {
            {(short) 0, 1, 0},
            {(short) 0, 1, 0},
            {(short) 0, 0, 0}
        };
        return k;
    }

    public static short[][] getMedian1x2() {
        short k[][] = {
            {(short) 0, 0, 0},
            {(short) 1, 1, 0},
            {(short) 0, 0, 0}
        };
        return k;
    }

    // p0 p1 p2
    // p3 p4 p5
    // p6 p7 p8
    //
    //
    public static short[][] getSizeDetector(short f[][]) {
        short a[][] = new short[f.length][f[0].length];
        int p[] = new int[9];
        int sum = 0;
        for (int x = 1; x < f.length - 1; x++)
            for (int y = 1; y < f[0].length - 1; y++) {
                sum = 0;
                p[0] = f[x - 1][y + 1];
                p[1] = f[x][y + 1];
                p[2] = f[x + 1][y + 1];
                p[3] = f[x - 1][y];
                p[4] = f[x][y];
                p[5] = f[x + 1][y];
                p[6] = f[x - 1][y - 1];
                p[7] = f[x][y - 1];
                p[8] = f[x + 1][y - 1];
                for (int i = 0; i < p.length; i++)
                    sum += p[i];
                if (sum > 255 * 5)
                    a[x][y] = 255;
                else
                    a[x][y] = 0;
            }
        return a;
    }

    public static float[][] getLaplacian5() {
        float k[][] = {
            {(float) -1, -1, -1, -1, -1},
            {(float) -1, -1, -1, -1, -1},
            {(float) -1, -1, 24, -1, -1},
            {(float) -1, -1, -1, -1, -1},
            {(float) -1, -1, -1, -1, -1}
        };
        return k;
    }

    public static float[][] getLaplacian3() {
        float k[][] = {
            {(float) 0, -1, 0},
            {(float) -1, 4, -1},
            {(float) 0, -1, 0}
        };
        return k;
    }

    public static float[][] getLaplacianPrewitt() {
        float k[][] = {
            {(float) -1, -1, -1},
            {(float) -1, 8, -1},
            {(float) -1, -1, -1}
        };
        return k;
    }

    public static double laplaceOfGaussian(double x,
                                           double y,
                                           double xc,
                                           double yc,
                                           double sigma) {
        ConvolutionUtils.t1 = sigma * sigma;
        ConvolutionUtils.t2 = ConvolutionUtils.t1 * ConvolutionUtils.t1;
        ConvolutionUtils.t5 = Math.pow(x - xc, 2.0);
        ConvolutionUtils.t7 = Math.pow(y - yc, 2.0);
        ConvolutionUtils.t11 =
                Math.exp(
                        -(ConvolutionUtils.t5 + ConvolutionUtils.t7) /
                ConvolutionUtils.t1 /
                2);
        ConvolutionUtils.t13 = 1 / Math.PI;
        ConvolutionUtils.t16 = Math.pow(2.0 * x - 2.0 * xc, 2.0);
        ConvolutionUtils.t18 = 1 /
                ConvolutionUtils.t2 /
                ConvolutionUtils.t1;
        ConvolutionUtils.t20 = ConvolutionUtils.t11 *
                ConvolutionUtils.t13;
        ConvolutionUtils.t23 = Math.pow(2.0 * y - 2.0 * yc, 2.0);
        ConvolutionUtils.t26 =
                1 / ConvolutionUtils.t2 *
                ConvolutionUtils.t11 *
                ConvolutionUtils.t13 -
                ConvolutionUtils.t16 *
                ConvolutionUtils.t18 *
                ConvolutionUtils.t20 /
                8 -
                ConvolutionUtils.t23 *
                ConvolutionUtils.t18 *
                ConvolutionUtils.t20 /
                8;
        return ConvolutionUtils.t26;
    }

    public static void printLaplaceOfGaussianKernel(int M, int N,
                                                    double sigma) {
        float k[][] = getLaplaceOfGaussianKernel(M, N, sigma);
        Mat2.printKernel(k, "LaplaceOfGaussian" + k.length);
    }

    public static float[][] getLaplaceOfGaussianKernel(int M, int N,
                                                       double sigma) {
        float k[][] = new float[M][N];
        int xc = M / 2;
        int yc = N / 2;
        for (int x = 0; x < k.length; x++)
            for (int y = 0; y < k[0].length; y++)
                k[x][y] = (float) laplaceOfGaussian(x, y, xc, yc, sigma);
        Mat2.normalize(k);
        return k;
    }

    public static float[][] getLaplacian9() {
        float k[][] = {
            {(float) -1, -1, -1, -1, -1, -1, -1, -1, -1},
            {(float) -1, -1, -1, -1, -1, -1, -1, -1, -1},
            {(float) -1, -1, -1, -1, -1, -1, -1, -1, -1},
            {(float) -1, -1, -1, 8, 8, 8, -1, -1, -1},
            {(float) -1, -1, -1, 8, 8, 8, -1, -1, -1},
            {(float) -1, -1, -1, 8, 8, 8, -1, -1, -1},
            {(float) -1, -1, -1, -1, -1, -1, -1, -1, -1},
            {(float) -1, -1, -1, -1, -1, -1, -1, -1, -1},
            {(float) -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        return k;
    }

    public static float[][] getHat13() {
        float k [][] = {
            {(float) 0, 0, 0, 0, 0, -1, -1, -1, 0, 0, 0, 0, 0},
            {(float) 0, 0, 0, -1, -1, -2, -2, -2, -1, -1, 0, 0, 0},
            {(float) 0, 0, -2, -2, -3, -3, -4, -3, -3, -2, -2, 0, 0},
            {(float) 0, -1, -2, -3, -3, -3, -2, -3, -3, -3, -2, -1, 0},
            {(float) 0, -1, -3, -3, -1, 4, 6, 4, -1, -3, -3, -1, 0},
            {(float) -1, -2, -3, -3, 4, 14, 19, 14, 4, -3, -3, -2, -1},
            {(float) -1, -2, -4, -2, 6, 19, 24, 19, 6, -2, -4, -2, -1},
            {(float) -1, -2, -3, -3, 4, 14, 19, 14, 4, -3, -3, -2, -1},
            {(float) 0, -1, -3, -3, -1, 4, 6, 4, -1, -3, -3, -1, 0},
            {(float) 0, -1, -2, -3, -3, -3, -2, -3, -3, -3, -2, -1, 0},
            {(float) 0, 0, -2, -2, -3, -3, -4, -3, -3, -2, -2, 0, 0},
            {(float) 0, 0, 0, -1, -1, -2, -2, -2, -1, -1, 0, 0, 0},
            {(float) 0, 0, 0, 0, 0, -1, -1, -1, 0, 0, 0, 0, 0}};
        return k;
    }

    public static float[][] getLp1() {
        float k[][] = {
            {(float) 1, 1, 1},
            {(float) 1, 2, 1},
            {(float) 1, 1, 1}
        };
        Mat2.scale(k, 1 / 10.0);
        return k;
    }

    public static float[][] getLp2() {
        float k[][] = {
            {(float) 1, 1, 1},
            {(float) 1, 4, 1},
            {(float) 1, 1, 1}
        };
        Mat2.scale(k, 1 / 12.0);
        return k;
    }

    public static float[][] getLp3() {
        float k[][] = {
            {(float) 1, 1, 1},
            {(float) 1, 12, 1},
            {(float) 1, 1, 1}
        };
        Mat2.scale(k, 1 / 20.0);
        return k;
    }

    public static float[][] getGabor7() {
        float k[][] = {

            {(float) 137, 126, 116, 123, 127, 128, 0},
            {(float) 148, 168, 133, 104, 117, 127, 0},
            {(float) 124, 173, 223, 158, 99, 113, 0},
            {(float) 117, 111, 181, 255, 181, 111, 0},
            {(float) 126, 113, 99, 158, 223, 173, 0},
            {(float) 128, 127, 117, 104, 133, 168, 0},
            {(float) 0, 0, 0, 0, 0, 0, 0}
        };
        Mat2.normalize(k);
        return k;
    }

    public static float[][] getMean9() {
        float s = (float) 81.0;
        float k[][] = {
            {1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 /
                s},
            {1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 /
                s},
            {1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 /
                s},
            {1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 /
                s},
            {1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 /
                s},
            {1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 /
                s},
            {1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 /
                s},
            {1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 /
                s},
            {1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 / s, 1 /
                s}};
        return k;
    }

    public static float[][] getMean3() {
        float k[][] = {
            {0.11111111f, 0.11111111f, 0.11111111f},
            {0.11111111f, 0.11111111f, 0.11111111f},
            {0.11111111f, 0.11111111f, 0.11111111f}};
        return k;
    }

    public static short[][] getMedianOctagon5x5() {
        short k[][] = {
            {(short) 0, 1, 1, 1, 0},
            {(short) 1, 1, 1, 1, 1},
            {(short) 1, 1, 1, 1, 1},
            {(short) 1, 1, 1, 1, 1},
            {(short) 0, 1, 1, 1, 0}};
        return k;
    }

    public static short[][] getMedianDiamond() {
        short k[][] = {
            {(short) 0, 0, 0, 1, 0, 0, 0},
            {(short) 0, 0, 1, 1, 1, 0, 0},
            {(short) 0, 1, 1, 1, 1, 1, 0},
            {(short) 1, 1, 1, 1, 1, 1, 1},
            {(short) 0, 1, 1, 1, 1, 1, 0},
            {(short) 0, 0, 1, 1, 1, 0, 0},
            {(short) 0, 0, 0, 1, 0, 0, 0}};
        return k;
    }

    public static short[][] getMedianCross3x3() {
        return new short[][]{
            {(short) 0, 1, 0},
            {(short) 1, 1, 1},
            {(short) 0, 1, 0}
        };
    }

    public static short[][] getMedianCross5x5() {
        short k[][] = {
            {(short) 1, 1, 1, 1, 1},
            {(short) 1, 1, 1, 1, 1},
            {(short) 1, 1, 1, 1, 1},
            {(short) 1, 1, 1, 1, 1},
            {(short) 1, 1, 1, 1, 1}};
        return k;
    }

    public static short[][] getMedianCross7x7() {
        short k[][] = {
            {(short) 0, 0, 0, 1, 0, 0, 0},
            {(short) 0, 0, 0, 1, 0, 0, 0},
            {(short) 0, 0, 0, 1, 0, 0, 0},
            {(short) 1, 1, 1, 1, 1, 1, 1},
            {(short) 0, 0, 0, 1, 0, 0, 0},
            {(short) 0, 0, 0, 1, 0, 0, 0},
            {(short) 0, 0, 0, 1, 0, 0, 0}};
        return k;
    }

    public static short[][] getMedianSquare7x7() {
        short k[][] = {
            {(short) 1, 1, 1, 1, 1, 1, 1},
            {(short) 1, 1, 1, 1, 1, 1, 1},
            {(short) 1, 1, 1, 1, 1, 1, 1},
            {(short) 1, 1, 1, 1, 1, 1, 1},
            {(short) 1, 1, 1, 1, 1, 1, 1},
            {(short) 1, 1, 1, 1, 1, 1, 1},
            {(short) 1, 1, 1, 1, 1, 1, 1}};
        return k;
    }

    public static float[][] getAverage3x3() {
        float k[][] = {
            {(float) 1, 1, 1},
            {(float) 1, 1, 1},
            {(float) 1, 1, 1}
        };
        Mat2.scale(k, 1 / 9.0);
        return k;
    }

    public static float[][] getHp1() {
        float k[][] = {
            {(float) 0, -1, 0},
            {(float) -1, 10, -1},
            {(float) 0, -1, 0}
        };
        Mat2.normalize(k);
        return k;
    }

    public static float[][] getHp2() {
        float k[][] = {
            {(float) 0, -1, 0},
            {(float) -1, 8, -1},
            {(float) 0, -1, 0}
        };
        Mat2.normalize(k);
        return k;
    }

    public static float[][] getHp3() {
        float k[][] = {
            {(float) 0, -1, 0},
            {(float) -1, 5, -1},
            {(float) 0, -1, 0}
        };
        Mat2.normalize(k);
        return k;
    }

    public static float[][] getHp4() {
        float k[][] = {
            {(float) 1, -2, 1},
            {(float) -2, 5, -2},
            {(float) 1, -2, 1}
        };
        return k;
    }

    public static float[][] getHp5() {
        float k[][] = {
            {(float) -1, -1, -1},
            {(float) -1, 9, -1},
            {(float) -1, -1, -1}
        };
        return k;
    }

    public static void main(String args[]) {
        printMehrotraAndZhang();
    }

    public static void printMehrotraAndZhang() {
        Mat2.printKernel(getMehrotraAndZhangKernel(9, 9, 1),
                "Mehrotra and Zhang");
    }

    public static float[][] getMehrotraAndZhangKernel(int M, int N,
                                                      double h) {
        float k[][] = new float[M][N];
        double deltaX = 1 / (M * 1.0);
        double deltaY = 1 / (N * 1.0);
        double startX = -1;
        double startY = -1;

        for (int x = 0; x < k.length; x++)
            for (int y = 0; y < k[0].length; y++) {
                k[x][y] = (float) mehrotraAndZhang(startX + deltaX * x,
                        startY + deltaY * y,
                        h);
            }
        Mat2.normalize(k);
        return k;
    }

    /*
    -100/9/h**2*(1-(x**2+y**2)**(3/2)/h**3+7.5*(x**2+y**2)**(3/2)/h**3*ln((x**2+
y**2)**(1/2)/h))
can be input into maple, optimized and the following will result.
This is the core optimal detector  described by Mehrotra and Zhan on pp6
of Graphical Models and Image Processing, v58, No. 1, Jan. 1996.
    */
    public static double mehrotraAndZhang(double x, double y, double h) {
        ConvolutionUtils.t1 = h * h;
        ConvolutionUtils.t3 = x * x;
        ConvolutionUtils.t4 = y * y;
        ConvolutionUtils.t5 = ConvolutionUtils.t3 + ConvolutionUtils.t4;
        ConvolutionUtils.t6 = Math.sqrt(ConvolutionUtils.t5);
        ConvolutionUtils.t7 = ConvolutionUtils.t6 * ConvolutionUtils.t5;
        ConvolutionUtils.t9 = 1 / ConvolutionUtils.t1 / h;
        return -100.0 / 9.0 / ConvolutionUtils.t1 *
                (1.0 - ConvolutionUtils.t7 * ConvolutionUtils.t9 +
                0.75E1 *
                ConvolutionUtils.t7 *
                ConvolutionUtils.t9 *
                Math.log(ConvolutionUtils.t6 / h));
    }

    public static final double gauss(
            double x, double y,
            double xc, double yc, double sigma) {
        double dx = x - xc;
        double dy = y - yc;
        double dx2 = dx * dx;
        double dy2 = dy * dy;
        double sigma2 = sigma * sigma;
        double oneOnSigma2 = 1 / sigma2;
        return
                Math.exp(-(dx2 + dy2) *
                oneOnSigma2 / 2) / Math.PI * oneOnSigma2 / 2;
    }

    public static final double gauss(
            double x,
            double xc, double sigma) {
        double oneOnSigmaSquaredOn2 = 1 / (sigma * sigma) / 2;
        return
                Math.exp(-((x - xc) * (x - xc)) *
                oneOnSigmaSquaredOn2) / Math.PI * oneOnSigmaSquaredOn2;
    }

    public static void printGaussKernel(
            int M, int N,
            double sigma, double centerMax) {
        short k[][] = new short[M][N];
        int xc = M / 2;
        int yc = N / 2;
        double scale = centerMax * 2 * Math.PI * sigma * sigma;
        for (int x = 0; x < k.length; x++)
            for (int y = 0; y < k[0].length; y++)
                k[x][y] = (short)
                        (scale * gauss(x, y, xc, yc, sigma));
        //Mat.printKernel(k,"gauss"+k.length);
    }

    public static void printGaussKernel(
            int M, int N,
            double sigma) {
        float k[][] = getGaussKernel(M, N, sigma);
        Mat2.printKernel(k, "gauss" + k.length);
    }

    public static float[][] getGaussKernel(
            int M, int N,
            double sigma) {
        float k[][] = new float[M][N];
        int xc = M / 2;
        int yc = N / 2;
        for (int x = 0; x < k.length; x++)
            for (int y = 0; y < k[0].length; y++)
                k[x][y] = (float) gauss(x, y, xc, yc, sigma);
        Mat2.normalize(k);
        return k;
    }

    public static double getMagnitudeOfTheDerivativeOfGauss(
            double x, double y,
            double xc, double yc, double sigma) {
        ConvolutionUtils.t2 = Math.pow(2.0 * x - 2.0 * xc, 2.0);
        ConvolutionUtils.t3 = sigma * sigma;
        ConvolutionUtils.t4 = ConvolutionUtils.t3 * ConvolutionUtils.t3;
        ConvolutionUtils.t5 = ConvolutionUtils.t4 * ConvolutionUtils.t4;
        ConvolutionUtils.t6 = 1 / ConvolutionUtils.t5;
        ConvolutionUtils.t9 = Math.pow(x - xc, 2.0);
        ConvolutionUtils.t11 = Math.pow(y - yc, 2.0);
        ConvolutionUtils.t16 = Math.pow(Math.exp(-(ConvolutionUtils.t9 + ConvolutionUtils.t11) / ConvolutionUtils.t3 / 2), 2.0);
        ConvolutionUtils.t17 = Math.PI * Math.PI;
        ConvolutionUtils.t19 = ConvolutionUtils.t16 / ConvolutionUtils.t17;
        ConvolutionUtils.t22 = Math.pow(2.0 * y - 2.0 * yc, 2.0);
        double ddx = ConvolutionUtils.t2 * ConvolutionUtils.t6 * ConvolutionUtils.t19;
        double ddy = ConvolutionUtils.t22 * ConvolutionUtils.t6 * ConvolutionUtils.t19;
        ConvolutionUtils.t26 = Math.sqrt(ddx + ddy);
        ConvolutionUtils.t27 = ConvolutionUtils.t26 / 4;
        return ConvolutionUtils.t27;
    }

    public static void printMagnitudeOfTheDerivativeOfGauss(
            int M, int N,
            double sigma) {
        //float k[][] = getMagnitudeOfTheDerivativeOfGauss(M, N, sigma);
        //Mat.printKernel(k,"MagnitudeOfTheDerivativeOfGauss"+k.length);
    }

    public static float[][] getMagnitudeOfTheDerivativeOfGauss(
            int M, int N,
            double sigma) {
        float k[][] = new float[M][N];
        int xc = M / 2;
        int yc = N / 2;
        for (int x = 0; x < k.length; x++)
            for (int y = 0; y < k[0].length; y++)
                k[x][y] = (float)
                        getMagnitudeOfTheDerivativeOfGauss(x, y, xc, yc, sigma);
        Mat2.normalize(k);
        return k;
    }

    public static float[][] getGauss3() {
        float k[][] = {
            {1, 2, 1},
            {2, 4, 2},
            {1, 2, 1}
        };
        Mat2.scale(k, 1 / 16.0);
        return k;
    }

    public static float[][] getGauss7() {
        float k [][] = {

            {1, 1, 2, 2, 2, 1, 1},
            {1, 2, 2, 4, 2, 2, 1},
            {2, 2, 4, 8, 4, 2, 2},
            {2, 4, 8, 16, 8, 4, 2},
            {2, 2, 4, 8, 4, 2, 2},
            {1, 2, 2, 4, 2, 2, 1},
            {1, 1, 2, 2, 2, 1, 1}
        };
        Mat2.normalize(k);
        return k;
    }

    public static float[][] getGauss15() {
        float k[][] = {
            {1.9045144E-7f, 9.671922E-7f, 3.8253193E-6f, 1.1782813E-5f, 2.8265502E-5f, 5.2806907E-5f, 7.6833596E-5f, 8.7063876E-5f, 7.6833596E-5f, 5.2806907E-5f, 2.8265502E-5f, 1.1782813E-5f, 3.8253193E-6f, 9.671922E-7f, 1.9045144E-7f},
            {9.671922E-7f, 4.9118075E-6f, 1.9426576E-5f, 5.9838065E-5f, 1.4354405E-4f, 2.681756E-4f, 3.901932E-4f, 4.4214682E-4f, 3.901932E-4f, 2.681756E-4f, 1.4354405E-4f, 5.9838065E-5f, 1.9426576E-5f, 4.9118075E-6f, 9.671922E-7f},
            {3.8253193E-6f, 1.9426576E-5f, 7.6833596E-5f, 2.3666414E-4f, 5.677278E-4f, 0.0010606551f, 0.001543244f, 0.0017487246f, 0.001543244f, 0.0010606551f, 5.677278E-4f, 2.3666414E-4f, 7.6833596E-5f, 1.9426576E-5f, 3.8253193E-6f},
            {1.1782813E-5f, 5.9838065E-5f, 2.3666414E-4f, 7.2897685E-4f, 0.0017487246f, 0.0032670477f, 0.0047535263f, 0.0053864513f, 0.0047535263f, 0.0032670477f, 0.0017487246f, 7.2897685E-4f, 2.3666414E-4f, 5.9838065E-5f, 1.1782813E-5f},
            {2.8265502E-5f, 1.4354405E-4f, 5.677278E-4f, 0.0017487246f, 0.004194972f, 0.00783724f, 0.011403117f, 0.012921424f, 0.011403117f, 0.00783724f, 0.004194972f, 0.0017487246f, 5.677278E-4f, 1.4354405E-4f, 2.8265502E-5f},
            {5.2806907E-5f, 2.681756E-4f, 0.0010606551f, 0.0032670477f, 0.00783724f, 0.014641892f, 0.021303825f, 0.024140399f, 0.021303825f, 0.014641892f, 0.00783724f, 0.0032670477f, 0.0010606551f, 2.681756E-4f, 5.2806907E-5f},
            {7.6833596E-5f, 3.901932E-4f, 0.001543244f, 0.0047535263f, 0.011403117f, 0.021303825f, 0.030996885f, 0.03512407f, 0.030996885f, 0.021303825f, 0.011403117f, 0.0047535263f, 0.001543244f, 3.901932E-4f, 7.6833596E-5f},
            {8.7063876E-5f, 4.4214682E-4f, 0.0017487246f, 0.0053864513f, 0.012921424f, 0.024140399f, 0.03512407f, 0.039800785f, 0.03512407f, 0.024140399f, 0.012921424f, 0.0053864513f, 0.0017487246f, 4.4214682E-4f, 8.7063876E-5f},
            {7.6833596E-5f, 3.901932E-4f, 0.001543244f, 0.0047535263f, 0.011403117f, 0.021303825f, 0.030996885f, 0.03512407f, 0.030996885f, 0.021303825f, 0.011403117f, 0.0047535263f, 0.001543244f, 3.901932E-4f, 7.6833596E-5f},
            {5.2806907E-5f, 2.681756E-4f, 0.0010606551f, 0.0032670477f, 0.00783724f, 0.014641892f, 0.021303825f, 0.024140399f, 0.021303825f, 0.014641892f, 0.00783724f, 0.0032670477f, 0.0010606551f, 2.681756E-4f, 5.2806907E-5f},
            {2.8265502E-5f, 1.4354405E-4f, 5.677278E-4f, 0.0017487246f, 0.004194972f, 0.00783724f, 0.011403117f, 0.012921424f, 0.011403117f, 0.00783724f, 0.004194972f, 0.0017487246f, 5.677278E-4f, 1.4354405E-4f, 2.8265502E-5f},
            {1.1782813E-5f, 5.9838065E-5f, 2.3666414E-4f, 7.2897685E-4f, 0.0017487246f, 0.0032670477f, 0.0047535263f, 0.0053864513f, 0.0047535263f, 0.0032670477f, 0.0017487246f, 7.2897685E-4f, 2.3666414E-4f, 5.9838065E-5f, 1.1782813E-5f},
            {3.8253193E-6f, 1.9426576E-5f, 7.6833596E-5f, 2.3666414E-4f, 5.677278E-4f, 0.0010606551f, 0.001543244f, 0.0017487246f, 0.001543244f, 0.0010606551f, 5.677278E-4f, 2.3666414E-4f, 7.6833596E-5f, 1.9426576E-5f, 3.8253193E-6f},
            {9.671922E-7f, 4.9118075E-6f, 1.9426576E-5f, 5.9838065E-5f, 1.4354405E-4f, 2.681756E-4f, 3.901932E-4f, 4.4214682E-4f, 3.901932E-4f, 2.681756E-4f, 1.4354405E-4f, 5.9838065E-5f, 1.9426576E-5f, 4.9118075E-6f, 9.671922E-7f},
            {1.9045144E-7f, 9.671922E-7f, 3.8253193E-6f, 1.1782813E-5f, 2.8265502E-5f, 5.2806907E-5f, 7.6833596E-5f, 8.7063876E-5f, 7.6833596E-5f, 5.2806907E-5f, 2.8265502E-5f, 1.1782813E-5f, 3.8253193E-6f, 9.671922E-7f, 1.9045144E-7f}};
//sum=0.9999999983459134
        return k;
    }
}