package gui.tree;

import futils.Futil;

import javax.swing.*;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;

public class FileTreeTest {
    public static void main(String[] args) {
        try {

            JFrame f = new JFrame("File Tree Test");
            File dir = Futil.getReadDirFileJTree("select file");
            classUtils.putils.ClassPathUtils.addClassPath(dir + "");

            JScrollPane jsp = getJscrollTree(dir);


            f.getContentPane().add(jsp);
            f.setSize(300, 300);
            f.addWindowListener(new WindowAdapter() {
                public void windowClosing(WindowEvent evt) {
                    System.exit(0);
                }
            });
            f.setVisible(true);
        } catch (FileNotFoundException e) {
            System.out.println("File " + args[0] + " not found");
        }
    }

    private static JScrollPane getJscrollTree(
            File dir)
            throws FileNotFoundException {
        final FileTree ft = new FileTree(dir + "");


        ft.addTreeSelectionListener(new TreeSelectionListener() {
            public void valueChanged(TreeSelectionEvent evt) {
                TreePath path = evt.getPath();
                String name = ft.getPathName(path);
                System.out.println(evt);
                System.out.println("File " + name + " has been "
                        + (evt.isAddedPath() ? "selected" : "deselected"));
            }
        });
        ft.getComponents();

        JScrollPane jsp = new JScrollPane(ft);
        return jsp;
    }
}
