package gui.touchtone;

import gui.run.RunTextField;


/**
 * Maintain state internally, so that the textfield
 * controller and view are consistent with the
 * keyboard controller and view.
 */
public class TouchToneModel {
    // the state of the system.

    private String stateString = "";

    private gui.run.RunTextField textFieldOld
            = new RunTextField("", 24) {
                public void run() {
                    setStateString(getText());
                }
            };

    public void dialPadKey(String s) {
        stateString = stateString + s;
        textFieldOld.setText(stateString);
    }

    public void setStateString(String _s) {
        stateString = _s;
    }

    public String getStateString() {
        return stateString;
    }

    public void setTextField(gui.run.RunTextField tf) {
        this.textFieldOld = tf;
    }

    public RunTextField getTextField() {
        return textFieldOld;
    }
}