package gui.run;

import javax.swing.*;
import java.awt.event.*;

/**
 * Just like the RunTextFieldOld except that each
 * char causes an invocation of the run method
 */
public abstract class RunTextField extends
        JTextField
        implements ActionListener,
        KeyListener,
        FocusListener,
        Runnable {
    private String originalText = null;
    private boolean isNotRunWithKeyPressed = true;

    /**
     * Invoked when a component gains the keyboard focus.
     */
    public void focusGained(FocusEvent e) {
    };

    /**
     * Invoked when a component loses the keyboard focus.
     */
    public void focusLost(FocusEvent e) {
        run();
    };

    public String getOriginalText() {
        return originalText;
    }

    public void keyTyped(KeyEvent e) {
 
    };

    public void keyPressed(KeyEvent e) {
    };

    public void keyReleased(KeyEvent e) {
        if (isNotRunWithKeyPressed)
            return;
        run();
    };
    public RunTextField(String text,boolean editable){
        this(text);
        initEditable(editable);
    }
    public RunTextField(String text) {
        super(text);
        originalText = text;
        initListeners();
    }

    private void initListeners() {
        addActionListener(this);
        ShortcutUtils.addShortcut(this);
        addKeyListener(this);
        addFocusListener(this);
    }
    public void removeListeners(){
        removeKeyListener(this);
        removeFocusListener(this);
    }


    public RunTextField() {
        this("");
    }

    public RunTextField(boolean isRunWithKeyPressed) {
        this("");
        this.isNotRunWithKeyPressed = isRunWithKeyPressed;
    }
    public RunTextField(int columns, boolean editable){
        this(columns);
        initEditable(editable);
    }

    private void initEditable(boolean editable) {
        setEditable(editable);
        setFocusable(editable);
    }

    public RunTextField(int columns) {
        super(columns);
        initListeners();
    }

    public RunTextField(String text,
                        int columns) {
        super(text, columns);
        initListeners();
    }

    public RunTextField(javax.swing.text.Document doc,
                        String text,
                        int columns) {
        super(doc, text, columns);
        initListeners();
    }

    public void actionPerformed(java.awt.event.ActionEvent e) {
        run();
    }

}