package gui.run;


import gui.ClosableJFrame;

import javax.swing.*;
import java.awt.*;

public class RadioButtonTest extends ClosableJFrame {

    Container c = getContentPane();
    ButtonGroup bg = new ButtonGroup();

    public void addRadioButton(RunRadio rr) {
        c.add(rr);
        bg.add(rr);
    }

    public RadioButtonTest() {
        super("Using Button Groups");

        c.setLayout(new FlowLayout());
        addRadioButton(new RunRadio("[blue") {
            public void run() {
                c.setBackground(Color.BLUE);
            }
        });
        addRadioButton(new RunRadio("[red") {
            public void run() {
                c.setBackground(Color.RED);
            }
        });
        addRadioButton(new RunRadio("[cyan") {
            public void run() {
                c.setBackground(Color.cyan);
            }
        });
        addRadioButton(new RunRadio("[yellow") {
            public void run() {
                c.setBackground(Color.yellow);
            }
        });
        addRadioButton(new RunRadio("[green") {
            public void run() {
                c.setBackground(Color.green);
            }
        });
        c.setBackground(Color.white);
        setSize(250, 300);
        setVisible(true);
    }

    public static void main(String args[]) {
        RadioButtonTest app = new RadioButtonTest();
    }

}