package gui.run;

import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import java.util.Observable;
import java.util.Observer;

/**
 * Created by IntelliJ IDEA.
 * User: dlyon
 * Date: Apr 18, 2005
 * Time: 3:08:55 PM
 * Copyright DocJava, 2005
 */
public class ObservableMatrix3d extends Observable{
    private Matrix3d m3d = new Matrix3d();

    public Matrix3d getValue() {
        return m3d;
    }

    public void setM3d(Matrix3d m3d) {
        this.m3d = m3d;
        setChanged();
        notifyObservers();
    }
    public static void main(String[] args) {
        ObservableMatrix3d om3 = new ObservableMatrix3d();
        om3.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                System.out.println(o);
            }
        });
        Matrix3d m3d = new Matrix3d();
        m3d.setIdentity();
        om3.setM3d(m3d);
    }

    public void setColumn(int i, Vector3d value) {
        m3d.setColumn(i,value);
        setChanged();
        notifyObservers();

    }
}
