package gui.run;

/*
      %Z%%M% %I% %E% %U%

***************************************************************
"Copyright (c) 2001 Sun Microsystems, Inc. All Rights Reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

-Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

-Redistribution in binary form must reproduce the above copyright notice, this
list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.

Neither the name of Sun Microsystems, Inc. or the names of contributors may be
used to endorse or promote products derived from this software without
specific prior written permission.

This software is provided "AS IS," without a warranty of any kind. ALL
EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

You acknowledge that Software is not designed,licensed or intended for use in
the design, construction, operation or maintenance of any nuclear facility."

****************************************************************************
*/

import j3d.utils.Java3DExplorerConstants;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;


public class IntChooser extends JPanel implements Java3DExplorerConstants {

    JComboBox combo;
    String[] choiceNames;
    int[] choiceValues;
    int current;
    Vector listeners = new Vector();


    public IntChooser(String name, String[] initChoiceNames, int[] initChoiceValues,
               int initValue) {
        if ((initChoiceValues != null) &&
                (initChoiceNames.length != initChoiceValues.length)) {
            throw new IllegalArgumentException(
                    "Name and Value arrays must have the same length");
        }
        choiceNames = new String[initChoiceNames.length];
        choiceValues = new int[initChoiceNames.length];
        System.arraycopy(initChoiceNames, 0, choiceNames, 0,
                choiceNames.length);
        if (initChoiceValues != null) {
            System.arraycopy(initChoiceValues, 0, choiceValues, 0,
                    choiceNames.length);
        } else {
            for (int i = 0; i < initChoiceNames.length; i++) {
                choiceValues[i] = i;
            }
        }

        // Create the combo box, select the init value
        combo = new JComboBox(choiceNames);
        combo.setSelectedIndex(current);
        combo.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox) e.getSource();
                int index = cb.getSelectedIndex();
                setValueIndex(index);
            }
        });

        // set the initial value
        current = 0;
        setValue(initValue);

        // layout to align left
        setLayout(new BorderLayout());
        Box box = new Box(BoxLayout.X_AXIS);
        add(box, BorderLayout.WEST);

        box.add(new JLabel(name));
        box.add(combo);
    }

    public IntChooser(String name, String[] initChoiceNames, int[] initChoiceValues) {
        this(name, initChoiceNames, initChoiceValues, initChoiceValues[0]);
    }

    public IntChooser(String name, String[] initChoiceNames, int initValue) {
        this(name, initChoiceNames, null, initValue);
    }

    public IntChooser(String name, String[] initChoiceNames) {
        this(name, initChoiceNames, null, 0);
    }

    public void addIntListener(IntListener listener) {
        listeners.add(listener);
    }

    public void removeIntListener(IntListener listener) {
        listeners.remove(listener);
    }

    public void setValueByName(String newName) {
        boolean found = false;
        int newIndex = 0;
        for (int i = 0; (!found) && (i < choiceNames.length); i++) {
            if (newName.equals(choiceNames[i])) {
                newIndex = i;
                found = true;
            }
        }
        if (found) {
            setValueIndex(newIndex);
        }
    }

    public void setValue(int newValue) {
        boolean found = false;
        int newIndex = 0;
        for (int i = 0; (!found) && (i < choiceValues.length); i++) {
            if (newValue == choiceValues[i]) {
                newIndex = i;
                found = true;
            }
        }
        if (found) {
            setValueIndex(newIndex);
        }
    }

    public int getValue() {
        return choiceValues[current];
    }

    public String getValueName() {
        return choiceNames[current];
    }

    public void setValueIndex(int newIndex) {
        boolean changed = (newIndex != current);
        current = newIndex;
        if (changed) {
            combo.setSelectedIndex(current);
            valueChanged();
        }
    }

    private void valueChanged() {
        // notify the listeners
        IntEvent event = new IntEvent(this, choiceValues[current]);
        for (Enumeration e = listeners.elements(); e.hasMoreElements();) {
            IntListener listener = (IntListener) e.nextElement();
            listener.intChanged(event);
        }
    }


}
