package gui.run;

import futils.Futil;

import javax.swing.*;
import java.awt.*;
import java.io.File;
import java.util.Vector;

/**
 * Copyright DocJava, inc. User: lyon Date: Aug 19, 2004 Time: 5:27:17 AM
 */
public class DirectoryGui {
    private Vector dirVector = new Vector();

    public JPanel getFilePanel(final String prompt) {
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        jp.setBorder(BorderFactory.createEtchedBorder());
        jp.setName(prompt);
        final JLabel directoryLabel = new JLabel("Directories");
        jp.add(new RunButton("...") {
            public void run() {
                File f = Futil.getReadDirFileJTree("select a directory");
                directoryLabel.setText(f.toString());
                addDirs(f.listFiles());
            }
        }, BorderLayout.EAST);


        jp.add(directoryLabel,
                BorderLayout.WEST);
        return jp;
    }


    public File[] getDirs() {
        File f[] = new File[dirVector.size()];
        dirVector.copyInto(f);
        return f;
    }

    public void addDirs(File f[]) {
        for (int i = 0; i < f.length; i++)
            dirVector.addElement(f[i]);
    }
}
