package gui.keyboard;

import gui.run.RunButton;
import gui.touchtone.Dialer;
import gui.touchtone.TouchToneModel;
import sound.dialTones.ToneMap;

import javax.swing.*;
import java.awt.*;

// gui.keyboard.KeyTest

public class KeyTestFrame extends gui.ClosableJFrame {

    public static void main(String args[]) {
        Dialer.dialer();

    }

    public static class LetterPanel extends JPanel {
        private final TouchToneModel ttm;
        private final MyRunButton enterButton;

        public LetterPanel(TouchToneModel ttm) {
            setLayout(new GridLayout(0, 1));
            // If you use lower case, then alter
            // the DTMF tones to the 1633 Hz frequence
            addButton("a");
            addButton("b");
            addButton("c");
            addButton("d");
            enterButton = new MyRunButton("Enter");
            add(enterButton);
            this.ttm = ttm;
        }

        private void addButton(String label) {
            add(
                    new RunButton(label) {
                        public void run() {
                            ttm.dialPadKey(getText());
                        }
                    });
        }


        private class MyRunButton extends RunButton {
            public MyRunButton(String label) {
                super(label);
            }

            public void run() {
                ToneMap tm = new ToneMap();

                tm.playNumber(ttm.getStateString());
            }
        }
    }
}